/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.engine;

import java.io.InterruptedIOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.jsr223.CachedGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.jsr223.ConcurrentBindings;
import org.apache.tinkerpop.gremlin.jsr223.GremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GremlinExecutor
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(GremlinExecutor.class);
    private GremlinScriptEngineManager gremlinScriptEngineManager;
    private final Map<String, Map<String, Map<String, Object>>> plugins;
    private final long evaluationTimeout;
    private final Bindings globalBindings;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Consumer<Bindings> beforeEval;
    private final Consumer<Bindings> afterSuccess;
    private final Consumer<Bindings> afterTimeout;
    private final BiConsumer<Bindings, Throwable> afterFailure;
    private final boolean suppliedExecutor;
    private final boolean suppliedScheduledExecutor;

    private GremlinExecutor(Builder builder, boolean suppliedExecutor, boolean suppliedScheduledExecutor) {
        this.executorService = builder.executorService;
        this.scheduledExecutorService = builder.scheduledExecutorService;
        this.beforeEval = builder.beforeEval;
        this.afterSuccess = builder.afterSuccess;
        this.afterTimeout = builder.afterTimeout;
        this.afterFailure = builder.afterFailure;
        this.plugins = builder.plugins;
        this.evaluationTimeout = builder.evaluationTimeout;
        this.globalBindings = builder.globalBindings;
        this.gremlinScriptEngineManager = new CachedGremlinScriptEngineManager();
        this.initializeGremlinScriptEngineManager();
        this.suppliedExecutor = suppliedExecutor;
        this.suppliedScheduledExecutor = suppliedScheduledExecutor;
    }

    public Optional<CompiledScript> compile(String script) throws ScriptException {
        return this.compile(script, Optional.empty());
    }

    public Optional<CompiledScript> compile(String script, Optional<String> language) throws ScriptException {
        String lang = language.orElse("gremlin-groovy");
        try {
            GremlinScriptEngine scriptEngine = this.gremlinScriptEngineManager.getEngineByName(lang);
            if (scriptEngine instanceof Compilable) {
                return Optional.of(((Compilable)scriptEngine).compile(script));
            }
            return Optional.empty();
        }
        catch (UnsupportedOperationException uoe) {
            return Optional.empty();
        }
    }

    public CompletableFuture<Object> eval(String script) {
        return this.eval(script, (String)null, new SimpleBindings());
    }

    public CompletableFuture<Object> eval(String script, Bindings boundVars) {
        return this.eval(script, (String)null, boundVars);
    }

    public CompletableFuture<Object> eval(String script, Map<String, Object> boundVars) {
        return this.eval(script, (String)null, new SimpleBindings(boundVars));
    }

    public CompletableFuture<Object> eval(String script, String language, Map<String, Object> boundVars) {
        return this.eval(script, language, new SimpleBindings(boundVars));
    }

    public CompletableFuture<Object> eval(String script, String language, Bindings boundVars) {
        return this.eval(script, language, boundVars, null, null);
    }

    public CompletableFuture<Object> eval(String script, String language, Map<String, Object> boundVars, Function<Object, Object> transformResult) {
        return this.eval(script, language, new SimpleBindings(boundVars), transformResult, null);
    }

    public CompletableFuture<Object> eval(String script, String language, Map<String, Object> boundVars, Consumer<Object> withResult) {
        return this.eval(script, language, new SimpleBindings(boundVars), null, withResult);
    }

    public CompletableFuture<Object> eval(String script, String language, Bindings boundVars, Function<Object, Object> transformResult, Consumer<Object> withResult) {
        LifeCycle lifeCycle = LifeCycle.build().transformResult(transformResult).withResult(withResult).create();
        return this.eval(script, language, boundVars, lifeCycle);
    }

    public CompletableFuture<Object> eval(String script, String language, Bindings boundVars, LifeCycle lifeCycle) {
        String lang = Optional.ofNullable(language).orElse("gremlin-groovy");
        logger.debug("Preparing to evaluate script - {} - in thread [{}]", (Object)script, (Object)Thread.currentThread().getName());
        SimpleBindings bindings = new SimpleBindings();
        bindings.putAll(this.globalBindings);
        bindings.putAll(boundVars);
        long scriptEvalTimeOut = lifeCycle.getEvaluationTimeoutOverride().orElse(this.evaluationTimeout);
        CompletableFuture<Object> evaluationFuture = new CompletableFuture<Object>();
        FutureTask<Void> evalFuture = new FutureTask<Void>(() -> {
            try {
                Object result;
                lifeCycle.getBeforeEval().orElse(this.beforeEval).accept(bindings);
                logger.debug("Evaluating script - {} - in thread [{}]", (Object)script, (Object)Thread.currentThread().getName());
                Object o = this.gremlinScriptEngineManager.getEngineByName(lang).eval(script, bindings);
                Object object = result = lifeCycle.getTransformResult().isPresent() ? lifeCycle.getTransformResult().get().apply(o) : o;
                if (lifeCycle.getWithResult().isPresent()) {
                    lifeCycle.getWithResult().get().accept(result);
                }
                lifeCycle.getAfterSuccess().orElse(this.afterSuccess).accept(bindings);
                evaluationFuture.complete(result);
            }
            catch (Throwable ex) {
                Throwable root;
                Throwable throwable = root = null == ex.getCause() ? ex : ExceptionUtils.getRootCause((Throwable)ex);
                if (root instanceof InterruptedException || root instanceof TraversalInterruptedException || root instanceof InterruptedIOException) {
                    lifeCycle.getAfterTimeout().orElse(this.afterTimeout).accept(bindings);
                    evaluationFuture.completeExceptionally(new TimeoutException(String.format("Evaluation exceeded the configured 'evaluationTimeout' threshold of %s ms or evaluation was otherwise cancelled directly for request [%s]: %s", scriptEvalTimeOut, script, root.getMessage())));
                }
                lifeCycle.getAfterFailure().orElse(this.afterFailure).accept(bindings, root);
                evaluationFuture.completeExceptionally(root);
            }
            return null;
        });
        WeakReference evaluationFutureRef = new WeakReference(evaluationFuture);
        Future<?> executionFuture = this.executorService.submit(evalFuture);
        if (scriptEvalTimeOut > 0L) {
            ScheduledFuture<?> sf = this.scheduledExecutorService.schedule(() -> {
                CompletableFuture ef;
                if (executionFuture.cancel(true) && (ef = (CompletableFuture)evaluationFutureRef.get()) != null) {
                    ef.completeExceptionally(new TimeoutException(String.format("Evaluation exceeded the configured 'evaluationTimeout' threshold of %s ms or evaluation was otherwise cancelled directly for request [%s]", scriptEvalTimeOut, script)));
                }
            }, scriptEvalTimeOut, TimeUnit.MILLISECONDS);
            evaluationFuture.handleAsync((v, t) -> {
                if (!sf.isDone()) {
                    logger.debug("Killing scheduled timeout on script evaluation - {} - as the eval completed (possibly with exception).", (Object)script);
                    sf.cancel(true);
                }
                return null;
            }, (Executor)this.scheduledExecutorService);
        }
        return evaluationFuture;
    }

    public Traversal.Admin eval(Bytecode bytecode, Bindings boundVars, String language, String traversalSource) throws ScriptException {
        String lang = Optional.ofNullable(language).orElse("gremlin-groovy");
        SimpleBindings bindings = new SimpleBindings();
        bindings.putAll(this.globalBindings);
        bindings.putAll(boundVars);
        return this.gremlinScriptEngineManager.getEngineByName(lang).eval(bytecode, (Bindings)bindings, traversalSource);
    }

    public GremlinScriptEngineManager getScriptEngineManager() {
        return this.gremlinScriptEngineManager;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public void close() throws Exception {
        this.closeAsync().join();
    }

    public CompletableFuture<Void> closeAsync() throws Exception {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        new Thread(() -> {
            if (!this.suppliedExecutor) {
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(180000L, TimeUnit.MILLISECONDS)) {
                        logger.warn("Timeout while waiting for ExecutorService of GremlinExecutor to shutdown.");
                    }
                }
                catch (InterruptedException ie) {
                    logger.warn("ExecutorService on GremlinExecutor may not have shutdown properly as shutdown thread terminated early.");
                }
            }
            if (!this.suppliedScheduledExecutor) {
                this.scheduledExecutorService.shutdown();
                try {
                    if (!this.scheduledExecutorService.awaitTermination(180000L, TimeUnit.MILLISECONDS)) {
                        logger.warn("Timeout while waiting for ScheduledExecutorService of GremlinExecutor to shutdown.");
                    }
                }
                catch (InterruptedException ie) {
                    logger.warn("ScheduledExecutorService on GremlinExecutor may not have shutdown properly as shutdown thread terminated early.");
                }
            }
            future.complete(null);
        }, "gremlin-executor-close").start();
        return future;
    }

    private void initializeGremlinScriptEngineManager() {
        for (Map.Entry<String, Map<String, Map<String, Object>>> config : this.plugins.entrySet()) {
            String language = config.getKey();
            Map<String, Map<String, Object>> pluginConfigs = config.getValue();
            for (Map.Entry<String, Map<String, Object>> pluginConfig : pluginConfigs.entrySet()) {
                try {
                    Class<?> clazz = Class.forName(pluginConfig.getKey());
                    try {
                        Method instanceMethod = clazz.getMethod("instance", new Class[0]);
                        this.gremlinScriptEngineManager.addPlugin((GremlinPlugin)instanceMethod.invoke(null, new Object[0]));
                    }
                    catch (Exception ex) {
                        Method builderMethod = clazz.getMethod("build", new Class[0]);
                        Object pluginBuilder = builderMethod.invoke(null, new Object[0]);
                        Class<?> builderClazz = pluginBuilder.getClass();
                        Map<String, Object> customizerConfigs = pluginConfig.getValue();
                        Method[] methods = builderClazz.getMethods();
                        for (Map.Entry<String, Object> customizerConfig : customizerConfigs.entrySet()) {
                            Method configMethod = Stream.of(methods).filter(m -> {
                                Class<?> type = customizerConfig.getValue().getClass();
                                return m.getName().equals(customizerConfig.getKey()) && m.getParameters().length <= 1 && ClassUtils.isAssignable(type, m.getParameters()[0].getType(), (boolean)true);
                            }).findFirst().orElseThrow(() -> new IllegalStateException("Could not find builder method '" + (String)customizerConfig.getKey() + "' on " + builderClazz.getCanonicalName()));
                            if (null == customizerConfig.getValue()) {
                                pluginBuilder = configMethod.invoke(pluginBuilder, new Object[0]);
                                continue;
                            }
                            pluginBuilder = configMethod.invoke(pluginBuilder, customizerConfig.getValue());
                        }
                        try {
                            Method appliesTo = builderClazz.getMethod("appliesTo", Collection.class);
                            pluginBuilder = appliesTo.invoke(pluginBuilder, Collections.singletonList(language));
                        }
                        catch (NoSuchMethodException appliesTo) {
                            // empty catch block
                        }
                        Method create = builderClazz.getMethod("create", new Class[0]);
                        this.gremlinScriptEngineManager.addPlugin((GremlinPlugin)create.invoke(pluginBuilder, new Object[0]));
                    }
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        this.gremlinScriptEngineManager.setBindings(this.globalBindings);
    }

    public static Builder build() {
        return new Builder();
    }

    public static class LifeCycle {
        private final Optional<Consumer<Bindings>> beforeEval;
        private final Optional<Function<Object, Object>> transformResult;
        private final Optional<Consumer<Object>> withResult;
        private final Optional<Consumer<Bindings>> afterSuccess;
        private final Optional<Consumer<Bindings>> afterTimeout;
        private final Optional<BiConsumer<Bindings, Throwable>> afterFailure;
        private final Optional<Long> evaluationTimeoutOverride;

        private LifeCycle(Builder builder) {
            this.beforeEval = Optional.ofNullable(builder.beforeEval);
            this.transformResult = Optional.ofNullable(builder.transformResult);
            this.withResult = Optional.ofNullable(builder.withResult);
            this.afterSuccess = Optional.ofNullable(builder.afterSuccess);
            this.afterTimeout = Optional.ofNullable(builder.afterTimeout);
            this.afterFailure = Optional.ofNullable(builder.afterFailure);
            this.evaluationTimeoutOverride = Optional.ofNullable(builder.evaluationTimeoutOverride);
        }

        @Deprecated
        public Optional<Long> getScriptEvaluationTimeoutOverride() {
            return this.evaluationTimeoutOverride;
        }

        public Optional<Long> getEvaluationTimeoutOverride() {
            return this.evaluationTimeoutOverride;
        }

        public Optional<Consumer<Bindings>> getBeforeEval() {
            return this.beforeEval;
        }

        public Optional<Function<Object, Object>> getTransformResult() {
            return this.transformResult;
        }

        public Optional<Consumer<Object>> getWithResult() {
            return this.withResult;
        }

        public Optional<Consumer<Bindings>> getAfterSuccess() {
            return this.afterSuccess;
        }

        public Optional<Consumer<Bindings>> getAfterTimeout() {
            return this.afterTimeout;
        }

        public Optional<BiConsumer<Bindings, Throwable>> getAfterFailure() {
            return this.afterFailure;
        }

        public static Builder build() {
            return new Builder();
        }

        public static class Builder {
            private Consumer<Bindings> beforeEval = null;
            private Function<Object, Object> transformResult = null;
            private Consumer<Object> withResult = null;
            private Consumer<Bindings> afterSuccess = null;
            private Consumer<Bindings> afterTimeout = null;
            private BiConsumer<Bindings, Throwable> afterFailure = null;
            private Long evaluationTimeoutOverride = null;

            public Builder beforeEval(Consumer<Bindings> beforeEval) {
                this.beforeEval = beforeEval;
                return this;
            }

            public Builder transformResult(Function<Object, Object> transformResult) {
                this.transformResult = transformResult;
                return this;
            }

            public Builder withResult(Consumer<Object> withResult) {
                this.withResult = withResult;
                return this;
            }

            public Builder afterSuccess(Consumer<Bindings> afterSuccess) {
                this.afterSuccess = afterSuccess;
                return this;
            }

            public Builder afterTimeout(Consumer<Bindings> afterTimeout) {
                this.afterTimeout = afterTimeout;
                return this;
            }

            public Builder afterFailure(BiConsumer<Bindings, Throwable> afterFailure) {
                this.afterFailure = afterFailure;
                return this;
            }

            @Deprecated
            public Builder scriptEvaluationTimeoutOverride(Long scriptEvaluationTimeoutOverride) {
                this.evaluationTimeoutOverride = scriptEvaluationTimeoutOverride;
                return this;
            }

            public Builder evaluationTimeoutOverride(Long evaluationTimeoutOverride) {
                this.evaluationTimeoutOverride = evaluationTimeoutOverride;
                return this;
            }

            public LifeCycle create() {
                return new LifeCycle(this);
            }
        }
    }

    public static final class Builder {
        private long evaluationTimeout = 8000L;
        private Map<String, Map<String, Map<String, Object>>> plugins = new HashMap<String, Map<String, Map<String, Object>>>();
        private ExecutorService executorService = null;
        private ScheduledExecutorService scheduledExecutorService = null;
        private Consumer<Bindings> beforeEval = b -> {};
        private Consumer<Bindings> afterSuccess = b -> {};
        private Consumer<Bindings> afterTimeout = b -> {};
        private BiConsumer<Bindings, Throwable> afterFailure = (b, e) -> {};
        private Bindings globalBindings = new ConcurrentBindings();

        private Builder() {
        }

        public Builder addPlugins(String engineName, Map<String, Map<String, Object>> plugins) {
            this.plugins.put(engineName, plugins);
            return this;
        }

        public Builder globalBindings(Bindings bindings) {
            this.globalBindings = new ConcurrentBindings((Map)bindings);
            return this;
        }

        @Deprecated
        public Builder scriptEvaluationTimeout(long scriptEvaluationTimeout) {
            this.evaluationTimeout = scriptEvaluationTimeout;
            return this;
        }

        public Builder evaluationTimeout(long evaluationTimeout) {
            this.evaluationTimeout = evaluationTimeout;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            this.scheduledExecutorService = scheduledExecutorService;
            return this;
        }

        public Builder beforeEval(Consumer<Bindings> beforeEval) {
            this.beforeEval = beforeEval;
            return this;
        }

        public Builder afterSuccess(Consumer<Bindings> afterSuccess) {
            this.afterSuccess = afterSuccess;
            return this;
        }

        public Builder afterTimeout(Consumer<Bindings> afterTimeout) {
            this.afterTimeout = afterTimeout;
            return this;
        }

        public Builder afterFailure(BiConsumer<Bindings, Throwable> afterFailure) {
            this.afterFailure = afterFailure;
            return this;
        }

        public GremlinExecutor create() {
            ScheduledExecutorService ses;
            ExecutorService es;
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("gremlin-executor-default-%d").build();
            AtomicBoolean poolCreatedByBuilder = new AtomicBoolean();
            AtomicBoolean suppliedExecutor = new AtomicBoolean(true);
            AtomicBoolean suppliedScheduledExecutor = new AtomicBoolean(true);
            this.executorService = es = Optional.ofNullable(this.executorService).orElseGet(() -> {
                poolCreatedByBuilder.set(true);
                suppliedExecutor.set(false);
                return Executors.newScheduledThreadPool(4, (ThreadFactory)threadFactory);
            });
            this.scheduledExecutorService = ses = Optional.ofNullable(this.scheduledExecutorService).orElseGet(() -> {
                suppliedScheduledExecutor.set(false);
                return poolCreatedByBuilder.get() ? (ScheduledExecutorService)es : Executors.newScheduledThreadPool(4, (ThreadFactory)threadFactory);
            });
            return new GremlinExecutor(this, suppliedExecutor.get(), suppliedScheduledExecutor.get());
        }
    }
}

