/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRegistryImpl;
import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;

@SimplyTimed
@Interceptor
@Priority(value=1010)
public class SimplyTimedInterceptor {
    private final MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.APPLICATION);

    @Inject
    SimplyTimedInterceptor() {
    }

    @AroundConstruct
    Object simplyTimedConstructor(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    Object simplyTimedMethod(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object simplyTimedTimeout(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object timedCallable(InvocationContext invocationContext, E element) throws Exception {
        Set<MetricID> ids = ((MetricsRegistryImpl)this.registry).getMemberToMetricMappings().getSimpleTimers(new CDIMemberInfoAdapter<AnnotatedElement>().convert(element));
        if (ids == null || ids.isEmpty()) {
            throw SmallRyeMetricsMessages.msg.noMetricMappedForMember(element);
        }
        List contexts = ids.stream().map(metricID -> {
            SimpleTimer metric = (SimpleTimer)this.registry.getSimpleTimers().get(metricID);
            if (metric == null) {
                throw SmallRyeMetricsMessages.msg.noMetricFoundInRegistry(MetricType.SIMPLE_TIMER, (MetricID)metricID);
            }
            return metric;
        }).map(SimpleTimer::time).collect(Collectors.toList());
        try {
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            for (SimpleTimer.Context timeContext : contexts) {
                timeContext.stop();
            }
        }
    }
}

