/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.transaction;

import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkAdapter;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.resource.spi.work.WorkEvent;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import jakarta.resource.spi.work.WorkRejectedException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class SimpleWorkManager
implements WorkManager {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, SimpleWorkManager.class);
    private final Executor executor;

    public SimpleWorkManager(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.executor = executor;
    }

    public void doWork(Work work) throws WorkException {
        if (work == null) {
            throw new NullPointerException("work is null");
        }
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        if (work == null) {
            throw new NullPointerException("work is null");
        }
        this.executeWork(WorkType.DO, work, startTimeout, executionContext, workListener);
    }

    public long startWork(Work work) throws WorkException {
        if (work == null) {
            throw new NullPointerException("work is null");
        }
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        if (work == null) {
            throw new NullPointerException("work is null");
        }
        return this.executeWork(WorkType.START, work, startTimeout, executionContext, workListener);
    }

    public void scheduleWork(Work work) throws WorkException {
        if (work == null) {
            throw new NullPointerException("work is null");
        }
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        if (work == null) {
            throw new NullPointerException("work is null");
        }
        this.executeWork(WorkType.SCHEDULE, work, startTimeout, executionContext, workListener);
    }

    private long executeWork(WorkType workType, Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        if (workListener == null) {
            workListener = new LoggingWorkListener(workType);
        }
        if (executionContext != null && executionContext.getXid() != null) {
            WorkRejectedException workRejectedException = new WorkRejectedException("SimpleWorkManager can not import an XID", "3");
            workListener.workRejected(new WorkEvent((Object)this, 2, work, (WorkException)workRejectedException));
            throw workRejectedException;
        }
        workListener.workAccepted(new WorkEvent((Object)this, 1, work, null));
        Worker worker = new Worker(work, (WorkListener)workListener, startTimeout);
        this.executor.execute(worker);
        if (workType == WorkType.DO) {
            try {
                worker.waitForCompletion();
            }
            catch (InterruptedException e) {
                WorkException workException = new WorkException("Work submission thread was interrupted", (Throwable)e);
                workException.setErrorCode("-1");
                throw workException;
            }
            WorkException workCompletedException = worker.getWorkException();
            if (workCompletedException != null) {
                throw workCompletedException;
            }
        } else if (workType == WorkType.START) {
            try {
                worker.waitForStart();
            }
            catch (InterruptedException e) {
                WorkException workException = new WorkException("Work submission thread was interrupted", (Throwable)e);
                workException.setErrorCode("-1");
                throw workException;
            }
            WorkException workCompletedException = worker.getWorkException();
            if (workCompletedException instanceof WorkRejectedException) {
                throw workCompletedException;
            }
        }
        return worker.getStartDelay();
    }

    private static final class LoggingWorkListener
    extends WorkAdapter {
        private final WorkType workType;

        private LoggingWorkListener(WorkType workType) {
            this.workType = workType;
        }

        public void workRejected(WorkEvent event) {
            if (this.workType == WorkType.DO || this.workType == WorkType.START) {
                return;
            }
            WorkException exception = event.getException();
            if (exception != null && "1".equals(exception.getErrorCode())) {
                logger.error(exception.getMessage());
            }
        }

        public void workCompleted(WorkEvent event) {
            if (this.workType == WorkType.DO) {
                return;
            }
            Object cause = event.getException();
            if (cause != null && cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause != null) {
                logger.error(event.getWork().toString(), (Throwable)cause);
            }
        }
    }

    private class Worker
    implements Runnable {
        private final Work work;
        private final WorkListener workListener;
        private final long startTimeout;
        private final long created = System.currentTimeMillis();
        private final CountDownLatch started = new CountDownLatch(1);
        private final CountDownLatch completed = new CountDownLatch(1);
        private long startDelay = -1L;
        private WorkException workException;

        public Worker(Work work, WorkListener workListener, long startTimeout) {
            this.work = work;
            this.workListener = workListener;
            this.startTimeout = startTimeout <= 0L ? Long.MAX_VALUE : startTimeout;
        }

        @Override
        public void run() {
            block10: {
                try {
                    this.startDelay = System.currentTimeMillis() - this.created;
                    if (this.startDelay > this.startTimeout) {
                        this.workException = new WorkRejectedException("Work not started within specified timeout " + this.startTimeout + "ms", "1");
                        this.workListener.workRejected(new WorkEvent((Object)this, 2, this.work, this.workException, this.startTimeout));
                        return;
                    }
                    this.workListener.workStarted(new WorkEvent((Object)SimpleWorkManager.this, 3, this.work, null));
                    this.started.countDown();
                    this.workException = null;
                    try {
                        this.work.run();
                    }
                    catch (Throwable e) {
                        try {
                            this.workException = new WorkCompletedException(e);
                            break block10;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.workListener.workCompleted(new WorkEvent((Object)SimpleWorkManager.this, 4, this.work, this.workException));
                        }
                    }
                    this.workListener.workCompleted(new WorkEvent((Object)SimpleWorkManager.this, 4, this.work, this.workException));
                }
                finally {
                    this.started.countDown();
                    this.completed.countDown();
                }
            }
        }

        public long getStartDelay() {
            return this.startDelay;
        }

        public WorkException getWorkException() {
            return this.workException;
        }

        public void waitForStart() throws InterruptedException {
            this.started.await();
        }

        public void waitForCompletion() throws InterruptedException {
            this.completed.await();
        }
    }

    public static enum WorkType {
        DO,
        START,
        SCHEDULE;

    }
}

