/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SecretKeys;
import jakarta.annotation.Priority;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@Priority(value=3100)
public class SecretKeysConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = 7291982039729980590L;
    private final Set<String> secrets;

    public SecretKeysConfigSourceInterceptor(Set<String> secrets) {
        this.secrets = secrets;
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (SecretKeys.isLocked() && this.isSecret(name)) {
            throw ConfigMessages.msg.notAllowed(name);
        }
        return context.proceed(name);
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        if (SecretKeys.isLocked()) {
            HashSet<String> names = new HashSet<String>();
            Iterator<String> namesIterator = context.iterateNames();
            while (namesIterator.hasNext()) {
                String name = namesIterator.next();
                if (this.secrets.contains(name)) continue;
                names.add(name);
            }
            return names.iterator();
        }
        return context.iterateNames();
    }

    @Override
    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        if (SecretKeys.isLocked()) {
            HashSet<ConfigValue> values = new HashSet<ConfigValue>();
            Iterator<ConfigValue> valuesIterator = context.iterateValues();
            while (valuesIterator.hasNext()) {
                ConfigValue value = valuesIterator.next();
                if (this.secrets.contains(value.getName())) continue;
                values.add(value);
            }
            return values.iterator();
        }
        return context.iterateValues();
    }

    private boolean isSecret(String name) {
        return this.secrets.contains(name);
    }
}

