/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.common.AbstractJoseProducer;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;

public class JoseJwtProducer
extends AbstractJoseProducer {
    public String processJwt(JwtToken jwt) {
        return this.processJwt(jwt, null, null);
    }

    public String processJwt(JwtToken jwt, JweEncryptionProvider theEncProvider, JwsSignatureProvider theSigProvider) {
        String data;
        super.checkProcessRequirements();
        if (this.isJweRequired() && theEncProvider == null && (theEncProvider = this.getInitializedEncryptionProvider(jwt.getJweHeaders())) == null) {
            throw new JwtException("Unable to encrypt JWT");
        }
        if (this.isJwsRequired()) {
            JwsJwtCompactProducer jws = new JwsJwtCompactProducer(jwt);
            if (jws.isPlainText()) {
                data = jws.getSignedEncodedJws();
            } else {
                if (theSigProvider == null) {
                    theSigProvider = this.getInitializedSignatureProvider(jws.getJwsHeaders());
                }
                if (theSigProvider == null) {
                    throw new JwtException("Unable to sign JWT");
                }
                data = jws.signWith(theSigProvider);
            }
            if (theEncProvider != null) {
                data = theEncProvider.encrypt(StringUtils.toBytesUTF8(data), jwt.getJweHeaders());
            }
        } else {
            JweJwtCompactProducer jwe = new JweJwtCompactProducer(jwt.getJweHeaders(), jwt.getClaims());
            data = jwe.encryptWith(theEncProvider);
        }
        return data;
    }
}

