/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.Session;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.DateConverter;

public class DateTextField
extends TextField<Date>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_PATTERN = "MM/dd/yyyy";
    private String datePattern = null;
    private final IConverter<Date> converter;

    public DateTextField(String id) {
        this(id, null, DateTextField.defaultDatePattern());
    }

    public DateTextField(String id, IModel<Date> model) {
        this(id, model, DateTextField.defaultDatePattern());
    }

    public DateTextField(String id, String datePattern) {
        this(id, null, datePattern);
    }

    public DateTextField(String id, IModel<Date> model, String datePattern) {
        super(id, model, Date.class);
        this.datePattern = datePattern;
        this.converter = new DateConverter(){
            private static final long serialVersionUID = 1L;

            public DateFormat getDateFormat(Locale locale) {
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                return new SimpleDateFormat(DateTextField.this.datePattern, locale);
            }
        };
    }

    protected IConverter<?> createConverter(Class<?> type) {
        if (Date.class.isAssignableFrom(type)) {
            return this.converter;
        }
        return null;
    }

    public String getTextFormat() {
        return this.datePattern;
    }

    private static String defaultDatePattern() {
        DateFormat format;
        Locale locale = Session.get().getLocale();
        if (locale != null && (format = DateFormat.getDateInstance(3, locale)) instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        return DEFAULT_PATTERN;
    }

    protected String[] getInputTypes() {
        return new String[]{"text", "date", "datetime", "datetime-local", "month", "time", "week"};
    }
}

