/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.Coverage;
import org.apache.batik.svggen.font.table.SingleSubst;

public class SingleSubstFormat2
extends SingleSubst {
    private int coverageOffset;
    private int glyphCount;
    private int[] substitutes;
    private Coverage coverage;

    protected SingleSubstFormat2(RandomAccessFile randomAccessFile, int n) throws IOException {
        this.coverageOffset = randomAccessFile.readUnsignedShort();
        this.glyphCount = randomAccessFile.readUnsignedShort();
        this.substitutes = new int[this.glyphCount];
        for (int i = 0; i < this.glyphCount; ++i) {
            this.substitutes[i] = randomAccessFile.readUnsignedShort();
        }
        randomAccessFile.seek(n + this.coverageOffset);
        this.coverage = Coverage.read(randomAccessFile);
    }

    @Override
    public int getFormat() {
        return 2;
    }

    @Override
    public int substitute(int n) {
        int n2 = this.coverage.findGlyph(n);
        if (n2 > -1) {
            return this.substitutes[n2];
        }
        return n;
    }
}

