/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.realm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.ldap.AbstractLdapRealm;
import org.apache.shiro.realm.ldap.DefaultLdapContextFactory;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveDirectoryGroupRealm
extends AbstractLdapRealm {
    private static final Logger log = LoggerFactory.getLogger(ActiveDirectoryGroupRealm.class);
    private static final String ROLE_NAMES_DELIMETER = ",";
    String KEYSTORE_PASS = "activeDirectoryRealm.systemPassword";
    private String hadoopSecurityCredentialPath;
    private Map<String, String> groupRolesMap;
    LdapContextFactory ldapContextFactory;

    public void setHadoopSecurityCredentialPath(String hadoopSecurityCredentialPath) {
        this.hadoopSecurityCredentialPath = hadoopSecurityCredentialPath;
    }

    public void setGroupRolesMap(Map<String, String> groupRolesMap) {
        this.groupRolesMap = groupRolesMap;
    }

    protected void onInit() {
        super.onInit();
        this.getLdapContextFactory();
    }

    public LdapContextFactory getLdapContextFactory() {
        if (this.ldapContextFactory == null) {
            if (log.isDebugEnabled()) {
                log.debug("No LdapContextFactory specified - creating a default instance.");
            }
            DefaultLdapContextFactory defaultFactory = new DefaultLdapContextFactory();
            defaultFactory.setPrincipalSuffix(this.principalSuffix);
            defaultFactory.setSearchBase(this.searchBase);
            defaultFactory.setUrl(this.url);
            defaultFactory.setSystemUsername(this.systemUsername);
            defaultFactory.setSystemPassword(this.getSystemPassword());
            this.ldapContextFactory = defaultFactory;
        }
        return this.ldapContextFactory;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        try {
            AuthenticationInfo info = this.queryForAuthenticationInfo(token, this.getLdapContextFactory());
            return info;
        }
        catch (javax.naming.AuthenticationException var5) {
            throw new AuthenticationException("LDAP authentication failed.", (Throwable)var5);
        }
        catch (NamingException var6) {
            String msg = "LDAP naming error while attempting to authenticate user.";
            throw new AuthenticationException(msg, (Throwable)var6);
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        try {
            AuthorizationInfo info = this.queryForAuthorizationInfo(principals, this.getLdapContextFactory());
            return info;
        }
        catch (NamingException var5) {
            String msg = "LDAP naming error while attempting to retrieve authorization for user [" + principals + "].";
            throw new AuthorizationException(msg, (Throwable)var5);
        }
    }

    private String getSystemPassword() {
        String password = "";
        if (StringUtils.isEmpty((String)this.hadoopSecurityCredentialPath)) {
            password = this.systemPassword;
        } else {
            try {
                Configuration configuration = new Configuration();
                configuration.set("hadoop.security.credential.provider.path", this.hadoopSecurityCredentialPath);
                CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)configuration).get(0);
                CredentialProvider.CredentialEntry credEntry = provider.getCredentialEntry(this.KEYSTORE_PASS);
                if (credEntry != null) {
                    password = new String(credEntry.getCredential());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        String userPrincipalName;
        LdapContext ctx;
        UsernamePasswordToken upToken;
        block4: {
            AuthenticationInfo authenticationInfo;
            upToken = (UsernamePasswordToken)token;
            ctx = null;
            try {
                userPrincipalName = upToken.getUsername();
                if (this.isValidPrincipalName(userPrincipalName).booleanValue()) break block4;
                authenticationInfo = null;
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(ctx);
                throw throwable;
            }
            LdapUtils.closeContext(ctx);
            return authenticationInfo;
        }
        if (this.principalSuffix != null && userPrincipalName.indexOf(64) < 0) {
            userPrincipalName = upToken.getUsername() + this.principalSuffix;
        }
        ctx = ldapContextFactory.getLdapContext((Object)userPrincipalName, (Object)upToken.getPassword());
        LdapUtils.closeContext((LdapContext)ctx);
        return this.buildAuthenticationInfo(upToken.getUsername(), upToken.getPassword());
    }

    private Boolean isValidPrincipalName(String userPrincipalName) {
        String userPrincipalWithoutDomain;
        if (userPrincipalName != null && (StringUtils.isNotEmpty((String)userPrincipalName) && userPrincipalName.contains("@") ? StringUtils.isNotEmpty((String)(userPrincipalWithoutDomain = userPrincipalName.split("@")[0].trim())) : StringUtils.isNotEmpty((String)userPrincipalName))) {
            return true;
        }
        return false;
    }

    protected AuthenticationInfo buildAuthenticationInfo(String username, char[] password) {
        if (this.principalSuffix != null && username.indexOf(64) > 1) {
            username = username.split("@")[0];
        }
        return new SimpleAuthenticationInfo((Object)username, (Object)password, this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        Set<String> roleNames;
        String username = (String)this.getAvailablePrincipal(principals);
        LdapContext ldapContext = ldapContextFactory.getSystemLdapContext();
        try {
            roleNames = this.getRoleNamesForUser(username, ldapContext);
        }
        finally {
            LdapUtils.closeContext((LdapContext)ldapContext);
        }
        return this.buildAuthorizationInfo(roleNames);
    }

    protected AuthorizationInfo buildAuthorizationInfo(Set<String> roleNames) {
        return new SimpleAuthorizationInfo(roleNames);
    }

    public List<String> searchForUserName(String containString, LdapContext ldapContext) throws NamingException {
        ArrayList<String> userNameList = new ArrayList<String>();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        String searchFilter = "(&(objectClass=*)(userPrincipalName=*" + containString + "*))";
        Object[] searchArguments = new Object[]{containString};
        NamingEnumeration<SearchResult> answer = ldapContext.search(this.searchBase, searchFilter, searchArguments, searchCtls);
        while (answer.hasMoreElements()) {
            Attributes attrs;
            SearchResult sr = answer.next();
            if (log.isDebugEnabled()) {
                log.debug("Retrieving userprincipalname names for user [" + sr.getName() + "]");
            }
            if ((attrs = sr.getAttributes()) == null) continue;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMore()) {
                Attribute attr = ae.next();
                if (!attr.getID().toLowerCase().equals("cn")) continue;
                userNameList.addAll(LdapUtils.getAllAttributeValues((Attribute)attr));
            }
        }
        return userNameList;
    }

    public Map<String, String> getListRoles() {
        HashMap<String, String> roles = new HashMap<String, String>();
        for (Map.Entry<String, String> pair : this.groupRolesMap.entrySet()) {
            roles.put(pair.getValue(), "*");
        }
        return roles;
    }

    private Set<String> getRoleNamesForUser(String username, LdapContext ldapContext) throws NamingException {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        String userPrincipalName = username;
        if (this.principalSuffix != null && userPrincipalName.indexOf(64) < 0) {
            userPrincipalName = userPrincipalName + this.principalSuffix;
        }
        String searchFilter = "(&(objectClass=*)(userPrincipalName=" + userPrincipalName + "))";
        Object[] searchArguments = new Object[]{userPrincipalName};
        NamingEnumeration<SearchResult> answer = ldapContext.search(this.searchBase, searchFilter, searchArguments, searchCtls);
        while (answer.hasMoreElements()) {
            Attributes attrs;
            SearchResult sr = answer.next();
            if (log.isDebugEnabled()) {
                log.debug("Retrieving group names for user [" + sr.getName() + "]");
            }
            if ((attrs = sr.getAttributes()) == null) continue;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMore()) {
                Attribute attr = ae.next();
                if (!attr.getID().equals("memberOf")) continue;
                Collection groupNames = LdapUtils.getAllAttributeValues((Attribute)attr);
                if (log.isDebugEnabled()) {
                    log.debug("Groups found for user [" + username + "]: " + groupNames);
                }
                Collection<String> rolesForGroups = this.getRoleNamesForGroups(groupNames);
                roleNames.addAll(rolesForGroups);
            }
        }
        return roleNames;
    }

    protected Collection<String> getRoleNamesForGroups(Collection<String> groupNames) {
        HashSet<String> roleNames = new HashSet<String>(groupNames.size());
        if (this.groupRolesMap != null) {
            for (String groupName : groupNames) {
                String strRoleNames = this.groupRolesMap.get(groupName);
                if (strRoleNames == null) continue;
                for (String roleName : strRoleNames.split(ROLE_NAMES_DELIMETER)) {
                    if (log.isDebugEnabled()) {
                        log.debug("User is member of group [" + groupName + "] so adding role [" + roleName + "]");
                    }
                    roleNames.add(roleName);
                }
            }
        }
        return roleNames;
    }
}

