/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.realm.ActiveDirectoryGroupRealm;
import org.apache.zeppelin.realm.LdapRealm;
import org.apache.zeppelin.rest.GetUserList;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.ticket.TicketContainer;
import org.apache.zeppelin.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/security")
@Produces(value={"application/json"})
public class SecurityRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityRestApi.class);

    @GET
    @Path(value="ticket")
    @ZeppelinApi
    public Response ticket() {
        ZeppelinConfiguration conf = ZeppelinConfiguration.create();
        String principal = SecurityUtils.getPrincipal();
        HashSet<String> roles = SecurityUtils.getRoles();
        String ticket = "anonymous".equals(principal) ? "anonymous" : TicketContainer.instance.getTicket(principal);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("principal", principal);
        data.put("roles", roles.toString());
        data.put("ticket", ticket);
        JsonResponse response = new JsonResponse(Response.Status.OK, "", data);
        LOG.warn(response.toString());
        return response.build();
    }

    @GET
    @Path(value="userlist/{searchText}")
    public Response getUserList(final @PathParam(value="searchText") String searchText) {
        ArrayList<String> usersList = new ArrayList<String>();
        ArrayList<String> rolesList = new ArrayList<String>();
        try {
            GetUserList getUserListObj = new GetUserList();
            Collection realmsList = SecurityUtils.getRealmsList();
            if (realmsList != null) {
                for (Realm realm : realmsList) {
                    String name = realm.getClass().getName();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("RealmClass.getName: " + name);
                    }
                    if (name.equals("org.apache.shiro.realm.text.IniRealm")) {
                        usersList.addAll(getUserListObj.getUserList((IniRealm)realm));
                        rolesList.addAll(getUserListObj.getRolesList((IniRealm)realm));
                        continue;
                    }
                    if (name.equals("org.apache.zeppelin.realm.LdapGroupRealm")) {
                        usersList.addAll(getUserListObj.getUserList((JndiLdapRealm)realm, searchText));
                        continue;
                    }
                    if (name.equals("org.apache.zeppelin.realm.LdapRealm")) {
                        usersList.addAll(getUserListObj.getUserList((LdapRealm)realm, searchText));
                        rolesList.addAll(getUserListObj.getRolesList((LdapRealm)realm));
                        continue;
                    }
                    if (name.equals("org.apache.zeppelin.realm.ActiveDirectoryGroupRealm")) {
                        usersList.addAll(getUserListObj.getUserList((ActiveDirectoryGroupRealm)realm, searchText));
                        continue;
                    }
                    if (!name.equals("org.apache.shiro.realm.jdbc.JdbcRealm")) continue;
                    usersList.addAll(getUserListObj.getUserList((JdbcRealm)realm));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception in retrieving Users from realms ", (Throwable)e);
        }
        ArrayList<String> autoSuggestUserList = new ArrayList<String>();
        ArrayList<String> autoSuggestRoleList = new ArrayList<String>();
        Collections.sort(usersList);
        Collections.sort(rolesList);
        Collections.sort(usersList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.matches(searchText + "(.*)") && o2.matches(searchText + "(.*)")) {
                    return 0;
                }
                if (o1.matches(searchText + "(.*)")) {
                    return -1;
                }
                return 0;
            }
        });
        int maxLength = 0;
        for (String user : usersList) {
            if (StringUtils.containsIgnoreCase((CharSequence)user, (CharSequence)searchText)) {
                autoSuggestUserList.add(user);
                ++maxLength;
            }
            if (maxLength != 5) continue;
            break;
        }
        for (String role : rolesList) {
            if (!StringUtils.containsIgnoreCase((CharSequence)role, (CharSequence)searchText)) continue;
            autoSuggestRoleList.add(role);
        }
        HashMap<String, ArrayList<String>> returnListMap = new HashMap<String, ArrayList<String>>();
        returnListMap.put("users", autoSuggestUserList);
        returnListMap.put("roles", autoSuggestRoleList);
        return new JsonResponse(Response.Status.OK, "", returnListMap).build();
    }
}

