/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.utils;

import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.realm.ActiveDirectoryGroupRealm;
import org.apache.zeppelin.realm.LdapRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final String ANONYMOUS = "anonymous";
    private static final HashSet<String> EMPTY_HASHSET = Sets.newHashSet();
    private static boolean isEnabled = false;
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);

    public static void setIsEnabled(boolean value) {
        isEnabled = value;
    }

    public static Boolean isValidOrigin(String sourceHost, ZeppelinConfiguration conf) throws UnknownHostException, URISyntaxException {
        String sourceUriHost = "";
        if (sourceHost != null && !sourceHost.isEmpty()) {
            sourceUriHost = new URI(sourceHost).getHost();
            sourceUriHost = sourceUriHost == null ? "" : sourceUriHost.toLowerCase();
        }
        sourceUriHost = sourceUriHost.toLowerCase();
        String currentHost = InetAddress.getLocalHost().getHostName().toLowerCase();
        return conf.getAllowedOrigins().contains("*") || currentHost.equals(sourceUriHost) || "localhost".equals(sourceUriHost) || conf.getAllowedOrigins().contains(sourceHost);
    }

    public static String getPrincipal() {
        if (!isEnabled) {
            return ANONYMOUS;
        }
        Subject subject = org.apache.shiro.SecurityUtils.getSubject();
        String principal = subject.isAuthenticated() ? subject.getPrincipal().toString() : ANONYMOUS;
        return principal;
    }

    public static Collection getRealmsList() {
        if (!isEnabled) {
            return Collections.emptyList();
        }
        String key = ThreadContext.SECURITY_MANAGER_KEY;
        DefaultWebSecurityManager defaultWebSecurityManager = (DefaultWebSecurityManager)ThreadContext.get((Object)key);
        Collection realms = defaultWebSecurityManager.getRealms();
        return realms;
    }

    public static HashSet<String> getRoles() {
        if (!isEnabled) {
            return EMPTY_HASHSET;
        }
        Subject subject = org.apache.shiro.SecurityUtils.getSubject();
        HashSet<String> roles = new HashSet<String>();
        Map<String, String> allRoles = null;
        if (subject.isAuthenticated()) {
            Collection realmsList = SecurityUtils.getRealmsList();
            for (Realm realm : realmsList) {
                String name = realm.getClass().getName();
                if (name.equals("org.apache.shiro.realm.text.IniRealm")) {
                    allRoles = ((IniRealm)realm).getIni().get((Object)"roles");
                    break;
                }
                if (name.equals("org.apache.zeppelin.realm.LdapRealm")) {
                    allRoles = ((LdapRealm)realm).getListRoles();
                    break;
                }
                if (!name.equals("org.apache.zeppelin.realm.ActiveDirectoryGroupRealm")) continue;
                allRoles = ((ActiveDirectoryGroupRealm)realm).getListRoles();
                break;
            }
            if (allRoles != null) {
                for (Map.Entry pair : allRoles.entrySet()) {
                    if (!subject.hasRole((String)pair.getKey())) continue;
                    roles.add((String)pair.getKey());
                }
            }
        }
        return roles;
    }

    public static boolean isAuthenticated() {
        if (!isEnabled) {
            return false;
        }
        return org.apache.shiro.SecurityUtils.getSubject().isAuthenticated();
    }
}

