/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.controller;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.arquillian.container.chameleon.Utils;
import org.arquillian.container.chameleon.controller.FileNameFromUrlExtractor;
import org.arquillian.container.chameleon.spi.model.ContainerAdapter;
import org.arquillian.container.chameleon.spi.model.Target;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.execution.Execution;
import org.arquillian.spacelift.task.net.DownloadTool;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.core.api.threading.ExecutorService;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;

public class DistributionController {
    private static final String PROGRESS_INDICATOR = ".";
    private static final int HALF_A_SECOND = 500;
    private ContainerAdapter targetAdapter;
    private String distributionDownloadFolder;

    public DistributionController(ContainerAdapter targetAdapter, String distributionDownloadFolder) {
        this.targetAdapter = targetAdapter;
        this.distributionDownloadFolder = distributionDownloadFolder;
    }

    public void setup(ContainerDef targetConfiguration, ExecutorService executor) throws Exception {
        if (this.requireDistribution(targetConfiguration)) {
            this.updateTargetConfiguration(targetConfiguration, this.resolveDistribution(executor));
        }
    }

    private boolean requireDistribution(ContainerDef targetConfiguration) {
        return this.targetAdapter.requireDistribution() && this.requiredConfigurationNotSet(targetConfiguration, this.targetAdapter) && (this.targetAdapter.type() == Target.Type.Embedded || this.targetAdapter.type() == Target.Type.Managed);
    }

    private File resolveDistribution(ExecutorService executor) {
        if (this.targetAdapter.distribution().toLowerCase().startsWith("http")) {
            return this.downloadUsingHttp();
        }
        return this.fetchFromMavenRepository(executor);
    }

    private File downloadUsingHttp() {
        String distribution = this.targetAdapter.distribution();
        String serverName = new FileNameFromUrlExtractor(distribution).extract();
        File targetDirectory = new File(new File(this.distributionDownloadFolder, "server"), serverName);
        if (this.serverAlreadyDownloaded(targetDirectory)) {
            return this.getDistributionHome(targetDirectory);
        }
        System.out.println("Arquillian Chameleon: downloading distribution from " + distribution);
        String targetArchive = targetDirectory + "/" + serverName + ".zip";
        Execution download = ((DownloadTool)Spacelift.task(DownloadTool.class)).from(distribution).to(targetArchive).execute();
        try {
            while (!download.isFinished()) {
                System.out.print(PROGRESS_INDICATOR);
                Thread.sleep(500L);
            }
            System.out.print(PROGRESS_INDICATOR);
            File compressedServer = (File)download.await();
            ((ExplodedExporter)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)serverName)).importFrom(compressedServer)).as(ExplodedExporter.class)).exportExploded(targetDirectory, PROGRESS_INDICATOR);
            compressedServer.delete();
            return this.getDistributionHome(targetDirectory);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private File fetchFromMavenRepository(ExecutorService executor) {
        final MavenCoordinate distributableCoordinate = Utils.toMavenCoordinate(this.targetAdapter.distribution());
        if (distributableCoordinate != null) {
            final File targetDirectory = new File(new File(this.distributionDownloadFolder, "server"), distributableCoordinate.getArtifactId() + "_" + distributableCoordinate.getVersion());
            if (this.serverAlreadyDownloaded(targetDirectory)) {
                return this.getDistributionHome(targetDirectory);
            }
            System.out.println("Arquillian Chameleon: downloading distribution " + distributableCoordinate.toCanonicalForm());
            Future uncompressDirectory = executor.submit((Callable)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return ((ExplodedExporter)((GenericArchive)((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(distributableCoordinate.toCanonicalForm())).withoutTransitivity()).asSingle(GenericArchive.class)).as(ExplodedExporter.class)).exportExploded(targetDirectory, DistributionController.PROGRESS_INDICATOR);
                }
            });
            try {
                while (!uncompressDirectory.isDone()) {
                    System.out.print(PROGRESS_INDICATOR);
                    Thread.sleep(500L);
                }
                System.out.println();
                return this.getDistributionHome((File)uncompressDirectory.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private boolean serverAlreadyDownloaded(File targetDirectory) {
        boolean exists = targetDirectory.exists();
        if (!exists) {
            targetDirectory.mkdirs();
        }
        return exists;
    }

    private void updateTargetConfiguration(ContainerDef targetConfiguration, File distributionHome) throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("dist", distributionHome.getAbsolutePath());
        for (Map.Entry configuration : this.targetAdapter.resolveConfiguration(values).entrySet()) {
            targetConfiguration.overrideProperty((String)configuration.getKey(), (String)configuration.getValue());
        }
    }

    private boolean requiredConfigurationNotSet(ContainerDef targetConfiguration, ContainerAdapter adapter) {
        String[] configurationKeys = adapter.configurationKeys();
        Map targetProperties = targetConfiguration.getContainerProperties();
        for (String key : configurationKeys) {
            if (targetProperties.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    private File getDistributionHome(File uncompressDirectory) {
        File[] currentDirectoryContent = uncompressDirectory.listFiles();
        if (currentDirectoryContent.length == 1 && currentDirectoryContent[0].isDirectory()) {
            return currentDirectoryContent[0];
        }
        return uncompressDirectory;
    }
}

