/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.task.io;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.task.Task;
import org.arquillian.spacelift.task.io.FileWriter;

public class WriteToFileTool
extends Task<Object, List<File>> {
    private List<WriteFileContentsTuple> fileContents = new ArrayList<WriteFileContentsTuple>();

    public WriteFileContentsTuple write(String content) {
        WriteFileContentsTuple contentsTuple = new WriteFileContentsTuple(content);
        this.fileContents.add(contentsTuple);
        return contentsTuple;
    }

    protected List<File> process(Object input) throws Exception {
        HashMap<File, String> contents = new HashMap<File, String>();
        for (WriteFileContentsTuple fileContent : this.fileContents) {
            if (fileContent.target == null) continue;
            contents.put(fileContent.target, fileContent.content);
        }
        return (List)((FileWriter)Spacelift.task(contents, FileWriter.class)).execute().await();
    }

    public class WriteFileContentsTuple {
        private String content;
        private File target;

        private WriteFileContentsTuple(String content) {
            this.content = content;
        }

        public WriteToFileTool to(File file) {
            this.target = file;
            return WriteToFileTool.this;
        }

        public WriteToFileTool to(String path) {
            return this.to(new File(path));
        }
    }
}

