/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.querybean.generator;

import com.avaje.ebean.annotation.DbArray;
import com.avaje.ebean.annotation.DbJson;
import com.avaje.ebean.annotation.DbJsonB;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.avaje.ebean.querybean.generator.PropertyType;
import org.avaje.ebean.querybean.generator.PropertyTypeArray;
import org.avaje.ebean.querybean.generator.PropertyTypeAssoc;
import org.avaje.ebean.querybean.generator.PropertyTypeEnum;
import org.avaje.ebean.querybean.generator.PropertyTypeMap;
import org.avaje.ebean.querybean.generator.Split;

public class ProcessingContext {
    private static final String EBEAN_TYPEQUERY_MF = "ebean-typequery.mf";
    private static final String META_INF = "META-INF";
    private static final String NEWLINE = "\n";
    private final Types typeUtils;
    private final Filer filer;
    private final Messager messager;
    private final PropertyTypeMap propertyTypeMap = new PropertyTypeMap();
    private final Set<String> packages = new LinkedHashSet<String>();
    private boolean writeOnce;

    public ProcessingContext(ProcessingEnvironment processingEnv) {
        this.typeUtils = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    public List<VariableElement> allFields(Element element) {
        ArrayList<VariableElement> list = new ArrayList<VariableElement>();
        this.gatherProperties(list, element);
        return list;
    }

    protected void gatherProperties(List<VariableElement> fields, Element element) {
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superclass = typeElement.getSuperclass();
        Element mappedSuper = this.typeUtils.asElement(superclass);
        if (this.isMappedSuper(mappedSuper)) {
            this.gatherProperties(fields, mappedSuper);
        }
        List<VariableElement> allFields = ElementFilter.fieldsIn(element.getEnclosedElements());
        for (VariableElement field : allFields) {
            if (this.ignoreField(field)) continue;
            fields.add(field);
        }
    }

    private boolean ignoreField(VariableElement field) {
        return this.isStaticOrTransient(field) || this.ignoreEbeanInternalFields(field);
    }

    private boolean ignoreEbeanInternalFields(VariableElement field) {
        String fieldName = field.getSimpleName().toString();
        return fieldName.startsWith("_ebean") || fieldName.startsWith("_EBEAN");
    }

    private boolean isStaticOrTransient(VariableElement field) {
        Set<Modifier> modifiers = field.getModifiers();
        return modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.TRANSIENT);
    }

    private boolean isMappedSuper(Element mappedSuper) {
        return mappedSuper.getAnnotation(MappedSuperclass.class) != null;
    }

    private boolean isEntityOrEmbedded(Element mappedSuper) {
        return mappedSuper.getAnnotation(Entity.class) != null || mappedSuper.getAnnotation(Embeddable.class) != null;
    }

    public static boolean dbJsonField(Element field) {
        return field.getAnnotation(DbJson.class) != null || field.getAnnotation(DbJsonB.class) != null;
    }

    public static boolean dbArrayField(Element field) {
        return field.getAnnotation(DbArray.class) != null;
    }

    public PropertyType getPropertyType(VariableElement field) {
        String fullType;
        TypeMirror typeMirror;
        TypeMirror currentType = typeMirror = field.asType();
        while (currentType != null) {
            PropertyType type = this.propertyTypeMap.getType(currentType.toString());
            if (type != null) {
                return type;
            }
            TypeElement fieldType = (TypeElement)this.typeUtils.asElement(currentType);
            currentType = fieldType == null ? null : fieldType.getSuperclass();
        }
        if (ProcessingContext.dbJsonField(field)) {
            return this.propertyTypeMap.getDbJsonType();
        }
        if (ProcessingContext.dbArrayField(field)) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            fullType = declaredType.getTypeArguments().get(0).toString();
            return new PropertyTypeArray(fullType, Split.shortName(fullType));
        }
        Element fieldType = this.typeUtils.asElement(typeMirror);
        if (fieldType != null) {
            TypeMirror argType;
            Element argElement;
            DeclaredType declaredType;
            List<? extends TypeMirror> typeArguments;
            if (fieldType.getKind() == ElementKind.ENUM) {
                fullType = typeMirror.toString();
                return new PropertyTypeEnum(fullType, Split.shortName(fullType));
            }
            if (this.isEntityOrEmbedded(fieldType)) {
                return this.createPropertyTypeAssoc(typeMirror.toString());
            }
            if (typeMirror.getKind() == TypeKind.DECLARED && (typeArguments = (declaredType = (DeclaredType)typeMirror).getTypeArguments()).size() == 1 && this.isEntityOrEmbedded(argElement = this.typeUtils.asElement(argType = typeArguments.get(0)))) {
                return this.createPropertyTypeAssoc(argElement.asType().toString());
            }
        }
        return null;
    }

    private PropertyType createPropertyTypeAssoc(String fullName) {
        String[] split = Split.split(fullName);
        String propertyName = "QAssoc" + split[1];
        String packageName = this.packageAppend(split[0], "query.assoc");
        return new PropertyTypeAssoc(propertyName, packageName);
    }

    private String packageAppend(String origPackage, String suffix) {
        if (origPackage == null) {
            return suffix;
        }
        return origPackage + "." + suffix;
    }

    public JavaFileObject createWriter(String factoryClassName) throws IOException {
        return this.filer.createSourceFile(factoryClassName, new Element[0]);
    }

    public void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    public void logNote(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    public void addPackage(String destPackage) {
        this.packages.add(destPackage);
    }

    public void writeManifest() {
        if (this.writeOnce) {
            return;
        }
        this.logNote("... writing manifest ebean-typequery.mf", new Object[0]);
        this.writeOnce = true;
        try {
            this.writeManifest(StandardLocation.CLASS_OUTPUT);
        }
        catch (IOException e) {
            this.logError(null, "Error writing manifest " + e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeManifest(JavaFileManager.Location location) throws IOException {
        try {
            FileObject descFile = this.filer.getResource(location, "", "META-INF/ebean-typequery.mf");
            Reader reader = descFile.openReader(true);
            try (BufferedReader br = new BufferedReader(reader);){
                String[] pkgs;
                String line = br.readLine();
                line = line.replace("packages:", "").trim();
                for (String pkg : pkgs = line.split(",")) {
                    this.packages.add(pkg.trim());
                }
            }
            this.messager.printMessage(Diagnostic.Kind.NOTE, "... re-read the manifest.");
        }
        catch (IOException descFile) {
            // empty catch block
        }
        FileObject resource = this.filer.createResource(location, "", "META-INF/ebean-typequery.mf", new Element[0]);
        Writer writer = resource.openWriter();
        writer.append("packages: ");
        int count = 0;
        for (String aPackage : this.packages) {
            if (count++ > 0) {
                writer.append(",");
            }
            writer.append(aPackage);
        }
        writer.append(NEWLINE).append(NEWLINE);
        writer.flush();
        writer.close();
    }
}

