/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.querybean.generator;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import org.avaje.ebean.querybean.generator.ProcessingContext;
import org.avaje.ebean.querybean.generator.SimpleQueryBeanWriter;

public class Processor
extends AbstractProcessor {
    private ProcessingContext processingContext;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingContext = new ProcessingContext(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(Entity.class.getCanonicalName());
        annotations.add(Embeddable.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        int entityCount = 0;
        int embeddableCount = 0;
        for (Element element : roundEnv.getElementsAnnotatedWith(Entity.class)) {
            this.generateQueryBeans(element);
            ++entityCount;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Embeddable.class)) {
            this.generateQueryBeans(element);
            ++embeddableCount;
        }
        this.processingContext.writeManifest();
        if (entityCount > 0 || embeddableCount > 0) {
            this.processingContext.logNote("Generated query beans for [" + entityCount + "] entities [" + embeddableCount + "] embeddable", new Object[0]);
        }
        return true;
    }

    private void generateQueryBeans(Element element) {
        try {
            SimpleQueryBeanWriter beanWriter = new SimpleQueryBeanWriter((TypeElement)element, this.processingContext);
            beanWriter.writeRootBean();
            beanWriter.writeAssocBean();
        }
        catch (Exception e) {
            this.processingContext.logError(element, "Error generating query beans: " + e, new Object[0]);
        }
    }
}

