/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.querybean.generator;

import java.io.IOException;
import java.io.Writer;
import org.avaje.ebean.querybean.generator.PropertyType;

public class PropertyMeta {
    private final String name;
    private final PropertyType type;

    public PropertyMeta(String name, PropertyType type) {
        this.name = name;
        this.type = type;
    }

    public boolean isAssociation() {
        return this.type.isAssociation();
    }

    public String getTypeDefn(String shortName, boolean assoc) {
        return this.type.getTypeDefn(shortName, assoc);
    }

    public void writeFieldDefn(Writer writer, String shortName, boolean assoc) throws IOException {
        writer.append("  public ");
        writer.append(this.getTypeDefn(shortName, assoc));
        writer.append(" ").append(this.name).append(";");
    }

    public void writeConstructorSimple(Writer writer, String shortName, boolean assoc) throws IOException {
        if (!this.type.isAssociation()) {
            writer.append("    this.").append(this.name).append(" = new ");
            this.type.writeConstructor(writer, this.name, assoc);
        }
    }

    public void writeConstructorAssoc(Writer writer, String shortName, boolean assoc) throws IOException {
        if (this.type.isAssociation()) {
            if (assoc) {
                writer.append("  ");
            }
            writer.append("    this.").append(this.name).append(" = new ");
            this.type.writeConstructor(writer, this.name, assoc);
        }
    }

    public void writeFieldAliasDefn(Writer writer, String shortName) throws IOException {
        writer.append("    public static ");
        writer.append(this.getTypeDefn(shortName, false));
        writer.append(" ").append(this.name).append(" = _alias.").append(this.name).append(";");
    }
}

