/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.querybean.generator;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.persistence.Entity;
import javax.tools.JavaFileObject;
import org.avaje.ebean.querybean.generator.ProcessingContext;
import org.avaje.ebean.querybean.generator.PropertyMeta;
import org.avaje.ebean.querybean.generator.PropertyType;

class SimpleQueryBeanWriter {
    static final String NEWLINE = "\n";
    private final Set<String> importTypes = new TreeSet<String>();
    private final List<PropertyMeta> properties = new ArrayList<PropertyMeta>();
    private final TypeElement element;
    private final ProcessingContext processingContext;
    private final String beanFullName;
    private boolean writingAssocBean;
    private String destPackage;
    private String origDestPackage;
    private String shortName;
    private String origShortName;
    private Writer writer;

    SimpleQueryBeanWriter(TypeElement element, ProcessingContext processingContext) {
        this.element = element;
        this.processingContext = processingContext;
        this.beanFullName = element.getQualifiedName().toString();
        this.destPackage = this.derivePackage(this.beanFullName) + ".query";
        this.shortName = this.deriveShortName(this.beanFullName);
        processingContext.addPackage(this.destPackage);
    }

    private void gatherPropertyDetails() {
        this.importTypes.add(this.beanFullName);
        this.importTypes.add("org.avaje.ebean.typequery.TQRootBean");
        this.importTypes.add("org.avaje.ebean.typequery.TypeQueryBean");
        this.importTypes.add("com.avaje.ebean.EbeanServer");
        this.addClassProperties();
    }

    private void addClassProperties() {
        List<VariableElement> fields = this.processingContext.allFields(this.element);
        for (VariableElement field : fields) {
            PropertyType type = this.processingContext.getPropertyType(field);
            if (type == null) continue;
            type.addImports(this.importTypes);
            this.properties.add(new PropertyMeta(field.getSimpleName().toString(), type));
        }
    }

    void writeRootBean() throws IOException {
        this.gatherPropertyDetails();
        if (this.isEntity()) {
            this.writer = this.createFileWriter();
            this.writePackage();
            this.writeImports();
            this.writeClass();
            this.writeAlias();
            this.writeFields();
            this.writeConstructors();
            this.writeStaticAliasClass();
            this.writeClassEnd();
            this.writer.flush();
            this.writer.close();
        }
    }

    private boolean isEntity() {
        return this.element.getAnnotation(Entity.class) != null;
    }

    void writeAssocBean() throws IOException {
        this.writingAssocBean = true;
        this.origDestPackage = this.destPackage;
        this.destPackage = this.destPackage + ".assoc";
        this.origShortName = this.shortName;
        this.shortName = "Assoc" + this.shortName;
        this.prepareAssocBeanImports();
        this.writer = this.createFileWriter();
        this.writePackage();
        this.writeImports();
        this.writeClass();
        this.writeFields();
        this.writeConstructors();
        this.writeClassEnd();
        this.writer.flush();
        this.writer.close();
    }

    private void prepareAssocBeanImports() {
        this.importTypes.remove("org.avaje.ebean.typequery.TQRootBean");
        this.importTypes.remove("com.avaje.ebean.EbeanServer");
        this.importTypes.add("org.avaje.ebean.typequery.TQAssocBean");
        if (this.isEntity()) {
            this.importTypes.add("org.avaje.ebean.typequery.TQProperty");
            this.importTypes.add(this.origDestPackage + ".Q" + this.origShortName);
        }
        Iterator<String> importsIterator = this.importTypes.iterator();
        String checkImportStart = this.destPackage + ".QAssoc";
        while (importsIterator.hasNext()) {
            String importType = importsIterator.next();
            if (!importType.startsWith(checkImportStart)) continue;
            importsIterator.remove();
        }
    }

    private void writeConstructors() throws IOException {
        if (this.writingAssocBean) {
            this.writeAssocBeanFetch();
            this.writeAssocBeanConstructor();
        } else {
            this.writeRootBeanConstructor();
        }
    }

    private void writeRootBeanConstructor() throws IOException {
        this.writer.append(NEWLINE);
        this.writer.append("  /**").append(NEWLINE);
        this.writer.append("   * Construct with a given EbeanServer.").append(NEWLINE);
        this.writer.append("   */").append(NEWLINE);
        this.writer.append("  public Q").append(this.shortName).append("(EbeanServer server) {").append(NEWLINE);
        this.writer.append("    super(").append(this.shortName).append(".class, server);").append(NEWLINE);
        this.writer.append("  }").append(NEWLINE);
        this.writer.append(NEWLINE);
        this.writer.append("  /**").append(NEWLINE);
        this.writer.append("   * Construct using the default EbeanServer.").append(NEWLINE);
        this.writer.append("   */").append(NEWLINE);
        this.writer.append("  public Q").append(this.shortName).append("() {").append(NEWLINE);
        this.writer.append("    super(").append(this.shortName).append(".class);").append(NEWLINE);
        this.writer.append("  }").append(NEWLINE);
        this.writer.append(NEWLINE);
        this.writer.append("  /**").append(NEWLINE);
        this.writer.append("   * Construct for Alias.").append(NEWLINE);
        this.writer.append("   */").append(NEWLINE);
        this.writer.append("  private Q").append(this.shortName).append("(boolean dummy) {").append(NEWLINE);
        this.writer.append("    super(dummy);").append(NEWLINE);
        this.writer.append("  }").append(NEWLINE);
    }

    private void writeAssocBeanFetch() throws IOException {
        if (this.isEntity()) {
            this.writeAssocBeanFetch("", "Eagerly fetch this association loading the specified properties.");
            this.writeAssocBeanFetch("Query", "Eagerly fetch this association using a 'query join' loading the specified properties.");
            this.writeAssocBeanFetch("Lazy", "Use lazy loading for this association loading the specified properties.");
        }
    }

    private void writeAssocBeanFetch(String fetchType, String comment) throws IOException {
        this.writer.append("  /**").append(NEWLINE);
        this.writer.append("   * ").append(comment).append(NEWLINE);
        this.writer.append("   */").append(NEWLINE);
        this.writer.append("  @SafeVarargs").append(NEWLINE);
        this.writer.append("  public final R fetch").append(fetchType).append("(TQProperty<Q").append(this.origShortName).append(">... properties) {").append(NEWLINE);
        this.writer.append("    return fetch").append(fetchType).append("Properties(properties);").append(NEWLINE);
        this.writer.append("  }").append(NEWLINE);
        this.writer.append(NEWLINE);
    }

    private void writeAssocBeanConstructor() throws IOException {
        this.writer.append("  public Q").append(this.shortName).append("(String name, R root) {").append(NEWLINE);
        this.writer.append("    super(name, root);").append(NEWLINE);
        this.writer.append("  }").append(NEWLINE);
    }

    private void writeFields() throws IOException {
        for (PropertyMeta property : this.properties) {
            property.writeFieldDefn(this.writer, this.shortName, this.writingAssocBean);
            this.writer.append(NEWLINE);
        }
        this.writer.append(NEWLINE);
    }

    private void writeClass() throws IOException {
        if (this.writingAssocBean) {
            this.writer.append("/**").append(NEWLINE);
            this.writer.append(" * Association query bean for ").append(this.shortName).append(".").append(NEWLINE);
            this.writer.append(" * ").append(NEWLINE);
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").append(NEWLINE);
            this.writer.append(" */").append(NEWLINE);
            this.writer.append("@TypeQueryBean").append(NEWLINE);
            this.writer.append("public class ").append("Q").append(this.shortName);
            this.writer.append("<R> extends TQAssocBean<").append(this.origShortName).append(",R> {").append(NEWLINE);
        } else {
            this.writer.append("/**").append(NEWLINE);
            this.writer.append(" * Query bean for ").append(this.shortName).append(".").append(NEWLINE);
            this.writer.append(" * ").append(NEWLINE);
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").append(NEWLINE);
            this.writer.append(" */").append(NEWLINE);
            this.writer.append("@TypeQueryBean").append(NEWLINE);
            this.writer.append("public class ").append("Q").append(this.shortName).append(" extends TQRootBean<").append(this.shortName).append(",Q").append(this.shortName).append("> {").append(NEWLINE);
        }
        this.writer.append(NEWLINE);
    }

    private void writeAlias() throws IOException {
        if (!this.writingAssocBean) {
            this.writer.append("  private static final Q").append(this.shortName).append(" _alias = new Q");
            this.writer.append(this.shortName).append("(true);").append(NEWLINE);
            this.writer.append(NEWLINE);
            this.writer.append("  /**").append(NEWLINE);
            this.writer.append("   * Return the shared 'Alias' instance used to provide properties to ").append(NEWLINE);
            this.writer.append("   * <code>select()</code> and <code>fetch()</code> ").append(NEWLINE);
            this.writer.append("   */").append(NEWLINE);
            this.writer.append("  public static Q").append(this.shortName).append(" alias() {").append(NEWLINE);
            this.writer.append("    return _alias;").append(NEWLINE);
            this.writer.append("  }").append(NEWLINE);
            this.writer.append(NEWLINE);
        }
    }

    private void writeStaticAliasClass() throws IOException {
        this.writer.append(NEWLINE);
        this.writer.append("  /**").append(NEWLINE);
        this.writer.append("   * Provides static properties to use in <em> select() and fetch() </em>").append(NEWLINE);
        this.writer.append("   * clauses of a query. Typically referenced via static imports. ").append(NEWLINE);
        this.writer.append("   */").append(NEWLINE);
        this.writer.append("  public static class Alias {").append(NEWLINE);
        for (PropertyMeta property : this.properties) {
            property.writeFieldAliasDefn(this.writer, this.shortName);
            this.writer.append(NEWLINE);
        }
        this.writer.append("  }").append(NEWLINE);
    }

    private void writeClassEnd() throws IOException {
        this.writer.append("}").append(NEWLINE);
    }

    private void writeImports() throws IOException {
        for (String importType : this.importTypes) {
            this.writer.append("import ").append(importType).append(";").append(NEWLINE);
        }
        this.writer.append(NEWLINE);
    }

    private void writePackage() throws IOException {
        this.writer.append("package ").append(this.destPackage).append(";").append(NEWLINE).append(NEWLINE);
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = this.processingContext.createWriter(this.destPackage + ".Q" + this.shortName);
        return jfo.openWriter();
    }

    private String derivePackage(String name) {
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return name.substring(0, pos);
    }

    private String deriveShortName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return name;
        }
        return name.substring(pos + 1);
    }
}

