/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.docker.swarm;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.DiscoveredContainer;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.DockerSwarmDiscoveryConfiguration;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.SwarmDiscoveryUtil;

public class DockerSwarmDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private SwarmDiscoveryUtil swarmDiscoveryUtil = null;

    public DockerSwarmDiscoveryStrategy(DiscoveryNode localDiscoveryNode, ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        String rawDockerNetworkNames = (String)((Object)this.getOrDefault("docker-network-names", DockerSwarmDiscoveryConfiguration.DOCKER_NETWORK_NAMES, null));
        String rawDockerServiceLabels = (String)((Object)this.getOrDefault("docker-service-labels", DockerSwarmDiscoveryConfiguration.DOCKER_SERVICE_LABELS, null));
        String rawDockerServiceNames = (String)((Object)this.getOrDefault("docker-service-names", DockerSwarmDiscoveryConfiguration.DOCKER_SERVICE_NAMES, null));
        Integer hazelcastPeerPort = (Integer)this.getOrDefault("hazelcast-peer-port", DockerSwarmDiscoveryConfiguration.HAZELCAST_PEER_PORT, Integer.valueOf(5701));
        String swarmMgrUri = (String)((Object)this.getOrDefault("swarm-mgr-uri", DockerSwarmDiscoveryConfiguration.SWARM_MGR_URI, null));
        Boolean skipVerifySsl = (Boolean)this.getOrDefault("skip-verify-ssl", DockerSwarmDiscoveryConfiguration.SKIP_VERIFY_SSL, Boolean.valueOf(false));
        try {
            URI swarmMgr = null;
            swarmMgr = swarmMgrUri == null && System.getenv("DOCKER_HOST") != null ? new URI(System.getenv("DOCKER_HOST")) : new URI(swarmMgrUri);
            this.swarmDiscoveryUtil = new SwarmDiscoveryUtil(rawDockerNetworkNames, rawDockerServiceLabels, rawDockerServiceNames, hazelcastPeerPort, false, swarmMgr, skipVerifySsl);
        }
        catch (Exception e) {
            String msg = "Unexpected error configuring SwarmDiscoveryUtil: " + e.getMessage();
            logger.severe(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        ArrayList<DiscoveryNode> toReturn = new ArrayList<DiscoveryNode>();
        try {
            Set<DiscoveredContainer> discoveredContainers = this.swarmDiscoveryUtil.discoverContainers();
            this.getLogger().info("discoverNodes() DiscoveredContainers[" + discoveredContainers.size() + "]: " + Arrays.toString(discoveredContainers.toArray(new DiscoveredContainer[0])));
            for (DiscoveredContainer container : discoveredContainers) {
                toReturn.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(container.getIp(), this.swarmDiscoveryUtil.getHazelcastPeerPort().intValue())));
            }
            return toReturn;
        }
        catch (Exception e) {
            this.getLogger().severe("discoverNodes() unexpected error: " + e.getMessage(), (Throwable)e);
            return toReturn;
        }
    }
}

