/*
 * Decompiled with CFR 0.152.
 */
package org.bitsofinfo.hazelcast.discovery.docker.swarm;

import com.hazelcast.nio.Address;
import com.hazelcast.spi.MemberAddressProvider;
import java.net.InetSocketAddress;
import java.net.URI;
import org.bitsofinfo.hazelcast.discovery.docker.swarm.SwarmDiscoveryUtil;

public class SwarmMemberAddressProvider
implements MemberAddressProvider {
    private static final String PROP_DOCKER_NETWORK_NAMES = "dockerNetworkNames";
    private static final String PROP_DOCKER_SERVICE_LABELS = "dockerServiceLabels";
    private static final String PROP_DOCKER_SERVICE_NAMES = "dockerServiceNames";
    private static final String PROP_HAZELCAST_PEER_PORT = "hazelcastPeerPort";
    public static final String PROP_SWARM_MGR_URI = "swarmMgrUri";
    public static final String PROP_SKIP_VERIFY_SSL = "skipVerifySsl";
    private SwarmDiscoveryUtil swarmDiscoveryUtil = null;

    public SwarmMemberAddressProvider() {
        String dockerNetworkNames = System.getProperty(PROP_DOCKER_NETWORK_NAMES);
        String dockerServiceLabels = System.getProperty(PROP_DOCKER_SERVICE_LABELS);
        String dockerServiceNames = System.getProperty(PROP_DOCKER_SERVICE_NAMES);
        Integer hazelcastPeerPort = Integer.valueOf(System.getProperty(PROP_HAZELCAST_PEER_PORT));
        String swarmMgrUri = System.getProperty(PROP_SWARM_MGR_URI);
        if (swarmMgrUri == null || swarmMgrUri.trim().isEmpty()) {
            swarmMgrUri = System.getenv("DOCKER_HOST");
        }
        Boolean skipVerifySsl = false;
        if (System.getProperty(PROP_SKIP_VERIFY_SSL) != null) {
            skipVerifySsl = Boolean.valueOf(System.getProperty(PROP_SKIP_VERIFY_SSL));
        }
        this.initialize(dockerNetworkNames, dockerServiceLabels, dockerServiceNames, hazelcastPeerPort, swarmMgrUri, skipVerifySsl);
    }

    public SwarmMemberAddressProvider(String dockerNetworkNames, String dockerServiceLabels, String dockerServiceNames, Integer hazelcastPeerPort) {
        String swarmMgrUri = System.getenv("DOCKER_HOST");
        Boolean skipVerifySsl = false;
        this.initialize(dockerNetworkNames, dockerServiceLabels, dockerServiceNames, hazelcastPeerPort, swarmMgrUri, skipVerifySsl);
    }

    private void initialize(String dockerNetworkNames, String dockerServiceLabels, String dockerServiceNames, Integer hazelcastPeerPort, String swarmMgrUri, Boolean skipVerifySsl) {
        int port = hazelcastPeerPort != null ? hazelcastPeerPort : 5701;
        try {
            URI swarmMgr = null;
            swarmMgr = swarmMgrUri == null || swarmMgrUri.trim().isEmpty() ? new URI(System.getenv("DOCKER_HOST")) : new URI(swarmMgrUri);
            this.swarmDiscoveryUtil = new SwarmDiscoveryUtil(dockerNetworkNames, dockerServiceLabels, dockerServiceNames, port, false, swarmMgr, skipVerifySsl);
        }
        catch (Exception e) {
            throw new RuntimeException("SwarmAddressPicker: Error constructing SwarmDiscoveryUtil: " + e.getMessage(), e);
        }
    }

    public InetSocketAddress getBindAddress() {
        Address addr = this.swarmDiscoveryUtil.getMyAddress();
        return new InetSocketAddress(addr.getHost(), addr.getPort());
    }

    public InetSocketAddress getPublicAddress() {
        Address addr = this.swarmDiscoveryUtil.getMyAddress();
        return new InetSocketAddress(addr.getHost(), addr.getPort());
    }
}

