/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.PacketCipherException;

public class PacketCipherChecks {
    protected static void checkBoundsInput(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        if (byArray == null) {
            throw PacketCipherException.from(new IllegalArgumentException("input was null"));
        }
        if (byArray2 == null) {
            throw PacketCipherException.from(new IllegalArgumentException("output was null"));
        }
        if (n < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input offset is negative"));
        }
        if (n3 < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("output offset is negative"));
        }
        if (n2 < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input len is negative"));
        }
        if (n > byArray.length - n2) {
            throw PacketCipherException.from(new DataLengthException("input buffer too short for offset + length"));
        }
    }

    static void checkBoundsInputAndOutputWithBlockSize_16(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        PacketCipherChecks.checkBoundsInputAndOutput(byArray, n, n2, byArray2, n3);
        if (n2 % 16 != 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input len not multiple of block size"));
        }
    }

    static void checkBoundsInputAndOutput(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        if (byArray == null) {
            throw PacketCipherException.from(new IllegalArgumentException("input was null"));
        }
        if (byArray2 == null) {
            throw PacketCipherException.from(new IllegalArgumentException("output was null"));
        }
        if (n < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input offset is negative"));
        }
        if (n3 < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("output offset is negative"));
        }
        if (n2 < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input len is negative"));
        }
        if (n > byArray.length - n2) {
            throw PacketCipherException.from(new DataLengthException("input buffer too short for offset + length"));
        }
        if (n3 > byArray2.length - n2) {
            throw PacketCipherException.from(new OutputLengthException("output buffer too short"));
        }
    }

    static void checkInputAndOutputAEAD(boolean bl, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws PacketCipherException {
        if (!bl) {
            PacketCipherChecks.checkInputAgainstRequiredLength(byArray, n3, n4);
        }
        int n5 = bl ? n2 + n4 : n2 - n4;
        PacketCipherChecks.checkOutputAgainstRequiredLength(byArray2, n3, n5);
    }

    static void checkInputAgainstRequiredLength(byte[] byArray, int n, int n2) throws PacketCipherException {
        if (n < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input offset is negative"));
        }
        if (n2 < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input len is negative"));
        }
        if (n > byArray.length - n2) {
            throw PacketCipherException.from(new DataLengthException("data too short"));
        }
    }

    static void checkOutputAgainstRequiredLength(byte[] byArray, int n, int n2) throws PacketCipherException {
        if (n < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("output offset is negative"));
        }
        if (n2 < 0) {
            throw PacketCipherException.from(new IllegalArgumentException("input len is negative"));
        }
        if (n > byArray.length - n2) {
            throw PacketCipherException.from(new DataLengthException("output buffer too short"));
        }
    }

    static int addCheckInputOverflow(int n, int n2) {
        assert (n >= 0);
        assert (n2 >= 0);
        try {
            return Math.addExact(n, n2);
        }
        catch (ArithmeticException arithmeticException) {
            throw new DataLengthException("too much input");
        }
    }

    protected static void checkKeyLength(int n) throws PacketCipherException {
        try {
            PacketCipherChecks.checkKeyLenIllegalArgumentException(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PacketCipherException.from(illegalArgumentException);
        }
    }

    protected static void checkKeyLenIllegalArgumentException(int n) {
        switch (n) {
            case 16: 
            case 24: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("key must be only 16, 24 or 32 bytes long");
            }
        }
    }

    protected static void checkKeyLengthExclude192(int n) throws PacketCipherException {
        try {
            PacketCipherChecks.checkKeyLenIllegalArgumentExceptionExclude192(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PacketCipherException.from(illegalArgumentException);
        }
    }

    protected static void checkKeyLenIllegalArgumentExceptionExclude192(int n) {
        switch (n) {
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new IllegalArgumentException("key must be only 16, or 32 bytes long");
            }
        }
    }
}

