/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipher;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.modes.AESCCMModePacketCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESNativeCCMPacketCipher
implements PacketCipher,
AESCCMModePacketCipher {
    @Override
    public int getOutputSize(boolean bl, CipherParameters cipherParameters, int n) {
        int n2 = this.getMacSize(bl, cipherParameters);
        return AESNativeCCMPacketCipher.getOutputSize(bl, n, n2);
    }

    @Override
    public int processPacket(boolean bl, CipherParameters cipherParameters, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws PacketCipherException {
        KeyParameter keyParameter;
        byte[] byArray3;
        byte[] byArray4;
        int n4;
        block4: {
            try {
                if (cipherParameters instanceof AEADParameters) {
                    AEADParameters aEADParameters = (AEADParameters)cipherParameters;
                    n4 = this.getCCMMacSize(bl, aEADParameters.getMacSize());
                    byArray4 = aEADParameters.getNonce();
                    byArray3 = aEADParameters.getAssociatedText();
                    keyParameter = aEADParameters.getKey();
                    break block4;
                }
                if (cipherParameters instanceof ParametersWithIV) {
                    ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
                    n4 = 8;
                    byArray4 = parametersWithIV.getIV();
                    byArray3 = null;
                    keyParameter = (KeyParameter)parametersWithIV.getParameters();
                    break block4;
                }
                throw new IllegalArgumentException("invalid parameters passed to CCM");
            }
            catch (Exception exception) {
                throw PacketCipherException.from(exception);
            }
        }
        byte[] byArray5 = keyParameter.getKey();
        return AESNativeCCMPacketCipher.processAEADPacketCipher(bl, byArray, n, n2, byArray2, n3, byArray3, byArray5, byArray4, n4);
    }

    private static int processAEADPacketCipher(boolean bl, byte[] byArray, int n, int n2, byte[] byArray2, int n3, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n4) throws PacketCipherException {
        int n5;
        int n6 = byArray2 != null ? byArray2.length - n3 : 0;
        try {
            n5 = AESNativeCCMPacketCipher.processPacket(bl, byArray4, byArray5, byArray3, n4, byArray, n, n2, byArray2, n3, n6);
        }
        catch (Exception exception) {
            throw PacketCipherException.from(exception);
        }
        return n5;
    }

    static native int getOutputSize(boolean var0, int var1, int var2);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10);

    public String toString() {
        return "CCM-PS[Native](AES[Native])";
    }
}

