/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.NativeServices;

public class DumpInfo {
    private static final String newLine = "\n";

    public static void main(String[] stringArray) {
        System.out.println(CryptoServicesRegistrar.getInfo());
        if (CryptoServicesRegistrar.isNativeEnabled()) {
            NativeServices nativeServices = CryptoServicesRegistrar.getNativeServices();
            System.out.println("Native Build Date: " + nativeServices.getBuildDate());
            System.out.println("Native Status: " + nativeServices.getStatusMessage());
            System.out.println("Native Variant: " + nativeServices.getVariant());
            System.out.println("Native Features: " + String.join((CharSequence)" ", nativeServices.getFeatureSet()));
            System.out.println("");
            String[][] stringArray2 = nativeServices.getVariantSelectionMatrix();
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray2.length > 0) {
                stringBuilder.append(newLine);
                stringBuilder.append("CPU Features and Variant availability.");
                stringBuilder.append(newLine);
                stringBuilder.append("--------------------------------------------------------------------------------");
                stringBuilder.append(newLine);
                stringBuilder.append(DumpInfo.pad("Variant", 10));
                stringBuilder.append(DumpInfo.pad("CPU features + or -:", 50));
                stringBuilder.append(DumpInfo.pad("Supported", 20));
                stringBuilder.append(newLine);
                stringBuilder.append("--------------------------------------------------------------------------------");
                stringBuilder.append(newLine);
                for (String[] stringArray3 : stringArray2) {
                    String string = DumpInfo.pad(stringArray3[0], 10);
                    String string2 = "";
                    for (int i = 1; i < stringArray3.length - 1; ++i) {
                        string2 = string2 + stringArray3[i];
                        string2 = string2 + " ";
                    }
                    string2 = DumpInfo.pad(string2.trim(), 50);
                    String string3 = stringArray3[stringArray3.length - 1];
                    stringBuilder.append(string);
                    stringBuilder.append(string2);
                    stringBuilder.append(string3);
                    stringBuilder.append(newLine);
                }
                stringBuilder.append(newLine);
            }
            System.out.println(stringBuilder);
        } else {
            System.out.println("Native Features: None");
        }
    }

    private static String pad(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }
}

