/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.initialization;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.checker.initialization.InitializationAnnotatedTypeFactory;
import org.checkerframework.checker.initialization.InitializationStore;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ThisLiteralNode;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TreeUtils;

public class InitializationTransfer<V extends CFAbstractValue<V>, T extends InitializationTransfer<V, T, S>, S extends InitializationStore<V, S>>
extends CFAbstractTransfer<V, S, T> {
    protected final InitializationAnnotatedTypeFactory<?, ?, ?, ?> atypeFactory;

    public InitializationTransfer(CFAbstractAnalysis<V, S, T> analysis) {
        super(analysis);
        this.atypeFactory = (InitializationAnnotatedTypeFactory)analysis.getTypeFactory();
    }

    @Override
    protected boolean isNotFullyInitializedReceiver(MethodTree methodTree) {
        if (super.isNotFullyInitializedReceiver(methodTree)) {
            return true;
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType receiverType = this.analysis.getTypeFactory().getAnnotatedType(methodTree).getReceiverType();
        if (receiverType != null) {
            return this.atypeFactory.isUnclassified(receiverType) || this.atypeFactory.isFree(receiverType);
        }
        return false;
    }

    protected List<VariableElement> initializedFieldsAfterCall(MethodInvocationNode node, ConditionalTransferResult<V, S> transferResult) {
        TypeElement clazzElem;
        ClassTree clazz;
        ArrayList<VariableElement> result = new ArrayList<VariableElement>();
        MethodInvocationTree tree = node.getTree();
        ExecutableElement method = TreeUtils.elementFromUse(tree);
        boolean isConstructor = method.getSimpleName().contentEquals("<init>");
        Node receiver = node.getTarget().getReceiver();
        String methodString = tree.getMethodSelect().toString();
        if (isConstructor && receiver instanceof ThisLiteralNode && methodString.equals("this")) {
            clazz = TreeUtils.enclosingClass(this.analysis.getTypeFactory().getPath(tree));
            clazzElem = TreeUtils.elementFromDeclaration(clazz);
            this.markInvariantFieldsAsInitialized(result, clazzElem);
        }
        if (isConstructor && receiver instanceof ThisLiteralNode && methodString.equals("super")) {
            clazz = TreeUtils.enclosingClass(this.analysis.getTypeFactory().getPath(tree));
            clazzElem = TreeUtils.elementFromDeclaration(clazz);
            TypeMirror superClass = clazzElem.getSuperclass();
            while (superClass != null && superClass.getKind() != TypeKind.NONE) {
                clazzElem = (TypeElement)this.analysis.getTypes().asElement(superClass);
                superClass = clazzElem.getSuperclass();
                this.markInvariantFieldsAsInitialized(result, clazzElem);
            }
        }
        return result;
    }

    protected void markInvariantFieldsAsInitialized(List<VariableElement> result, TypeElement clazzElem) {
        List<VariableElement> fields = ElementFilter.fieldsIn(clazzElem.getEnclosedElements());
        for (VariableElement field : fields) {
            AnnotatedTypeMirror fieldAnno;
            if (((Symbol)((Object)field)).type.tsym.completer != null || !(fieldAnno = this.atypeFactory.getAnnotatedType(field)).hasAnnotation(this.atypeFactory.getFieldInvariantAnnotation())) continue;
            result.add(field);
        }
    }

    @Override
    public TransferResult<V, S> visitAssignment(AssignmentNode n, TransferInput<V, S> in) {
        TransferResult<V, S> result = super.visitAssignment(n, in);
        assert (result instanceof RegularTransferResult);
        FlowExpressions.Receiver expr = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), n.getTarget());
        if (!expr.containsUnknown() && expr instanceof FlowExpressions.FieldAccess) {
            FlowExpressions.FieldAccess fa = (FlowExpressions.FieldAccess)expr;
            ((InitializationStore)result.getRegularStore()).addInitializedField(fa);
        }
        return result;
    }

    @Override
    public TransferResult<V, S> visitFieldAccess(FieldAccessNode n, TransferInput<V, S> p) {
        AnnotatedTypeMirror fieldAnno;
        TransferResult<V, S> result = super.visitFieldAccess(n, p);
        assert (!result.containsTwoStores());
        InitializationStore store = (InitializationStore)result.getRegularStore();
        if (store.isFieldInitialized(n.getElement()) && n.getReceiver() instanceof ThisLiteralNode && (fieldAnno = this.analysis.getTypeFactory().getAnnotatedType(n.getElement())).hasAnnotation(this.atypeFactory.getFieldInvariantAnnotation())) {
            AnnotationMirror inv = this.atypeFactory.getFieldInvariantAnnotation();
            CFAbstractValue oldResultValue = (CFAbstractValue)result.getResultValue();
            Object refinedResultValue = this.analysis.createSingleAnnotationValue(inv, oldResultValue.getType().getUnderlyingType());
            Object newResultValue = refinedResultValue.mostSpecific(oldResultValue, null);
            result.setResultValue(newResultValue);
        }
        return result;
    }

    @Override
    public TransferResult<V, S> visitMethodInvocation(MethodInvocationNode n, TransferInput<V, S> in) {
        TransferResult<V, S> result = super.visitMethodInvocation(n, in);
        assert (result instanceof ConditionalTransferResult);
        List<VariableElement> newlyInitializedFields = this.initializedFieldsAfterCall(n, (ConditionalTransferResult)result);
        if (newlyInitializedFields.size() > 0) {
            for (VariableElement f : newlyInitializedFields) {
                ((InitializationStore)result.getThenStore()).addInitializedField(f);
                ((InitializationStore)result.getElseStore()).addInitializedField(f);
            }
        }
        return result;
    }
}

