/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.checker.lock.qual.LockHeld;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.AnnotationUtils;

public class LockStore
extends CFAbstractStore<CFValue, LockStore> {
    protected boolean inConstructorOrInitializer = false;
    protected final AnnotationMirror LOCKHELD = AnnotationUtils.fromClass(this.analysis.getTypeFactory().getElementUtils(), LockHeld.class);

    public LockStore(CFAbstractAnalysis<CFValue, LockStore, ?> analysis, boolean sequentialSemantics) {
        super(analysis, sequentialSemantics);
    }

    public LockStore(CFAbstractAnalysis<CFValue, LockStore, ?> analysis, CFAbstractStore<CFValue, LockStore> other) {
        super(other);
        this.inConstructorOrInitializer = ((LockStore)other).inConstructorOrInitializer;
    }

    @Override
    public LockStore leastUpperBound(LockStore other) {
        LockStore newStore = super.leastUpperBound(other);
        newStore.inConstructorOrInitializer = this.inConstructorOrInitializer && other.inConstructorOrInitializer;
        return newStore;
    }

    public void insertExactValue(FlowExpressions.Receiver r, AnnotationMirror a) {
        this.insertExactValue(r, (CFValue)this.analysis.createSingleAnnotationValue(a, r.getType()));
    }

    public void insertExactValue(FlowExpressions.Receiver r, CFValue value) {
        if (value == null) {
            return;
        }
        if (r.containsUnknown()) {
            return;
        }
        if (r instanceof FlowExpressions.LocalVariable) {
            Element localVar = ((FlowExpressions.LocalVariable)r).getElement();
            this.localVariableValues.put(localVar, value);
        } else if (r instanceof FlowExpressions.FieldAccess) {
            FlowExpressions.FieldAccess fieldAcc = (FlowExpressions.FieldAccess)r;
            if (this.sequentialSemantics || fieldAcc.isUnmodifiableByOtherCode()) {
                this.fieldValues.put(fieldAcc, value);
            }
        } else if (r instanceof FlowExpressions.PureMethodCall) {
            FlowExpressions.PureMethodCall method = (FlowExpressions.PureMethodCall)r;
            if (this.sequentialSemantics) {
                this.methodValues.put(method, value);
            }
        } else if (r instanceof FlowExpressions.ArrayAccess) {
            FlowExpressions.ArrayAccess arrayAccess = (FlowExpressions.ArrayAccess)r;
            if (this.sequentialSemantics) {
                this.arrayValues.put(arrayAccess, value);
            }
        } else if (r instanceof FlowExpressions.ThisReference) {
            FlowExpressions.ThisReference thisRef = (FlowExpressions.ThisReference)r;
            if (this.sequentialSemantics || thisRef.isUnmodifiableByOtherCode()) {
                this.thisValue = value;
            }
        }
    }

    public void setInConstructorOrInitializer() {
        this.inConstructorOrInitializer = true;
    }

    @Override
    public @Nullable CFValue getValue(FlowExpressions.Receiver expr) {
        if (this.inConstructorOrInitializer) {
            FlowExpressions.FieldAccess fieldAcc;
            if (expr instanceof FlowExpressions.ThisReference) {
                this.initializeThisValue(this.LOCKHELD, expr.getType());
                return (CFValue)this.thisValue;
            }
            if (expr instanceof FlowExpressions.FieldAccess && !(fieldAcc = (FlowExpressions.FieldAccess)expr).isStatic() && fieldAcc.getReceiver() instanceof FlowExpressions.ThisReference) {
                this.insertValue((FlowExpressions.Receiver)fieldAcc, this.LOCKHELD);
                return (CFValue)this.fieldValues.get(fieldAcc);
            }
        }
        return (CFValue)super.getValue(expr);
    }

    @Override
    protected void internalDotOutput(StringBuilder result) {
        result.append("  inConstructorOrInitializer = " + this.inConstructorOrInitializer + "\\n");
        super.internalDotOutput(result);
    }
}

