/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.xml.ws.Holder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.CFGDOTVisualizer;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.javacutil.BasicTypeProcessor;
import org.checkerframework.javacutil.TreeUtils;

public class JavaSource2CFGDOT {
    public static void main(String[] args) {
        if (args.length < 2) {
            JavaSource2CFGDOT.printUsage();
            System.exit(1);
        }
        String input = args[0];
        String output = args[1];
        File file = new File(input);
        if (!file.canRead()) {
            JavaSource2CFGDOT.printError("Cannot read input file: " + file.getAbsolutePath());
            JavaSource2CFGDOT.printUsage();
            System.exit(1);
        }
        String method = "test";
        String clas = "Test";
        boolean pdf = false;
        boolean error = false;
        for (int i = 2; i < args.length; ++i) {
            if (args[i].equals("-pdf")) {
                pdf = true;
                continue;
            }
            if (args[i].equals("-method")) {
                if (i >= args.length - 1) {
                    JavaSource2CFGDOT.printError("Did not find <name> after -method.");
                    continue;
                }
                method = args[++i];
                continue;
            }
            if (args[i].equals("-class")) {
                if (i >= args.length - 1) {
                    JavaSource2CFGDOT.printError("Did not find <name> after -class.");
                    continue;
                }
                clas = args[++i];
                continue;
            }
            JavaSource2CFGDOT.printError("Unknown command line argument: " + args[i]);
            error = true;
        }
        if (error) {
            System.exit(1);
        }
        JavaSource2CFGDOT.generateDOTofCFG(input, output, method, clas, pdf);
    }

    protected static void printError(String string) {
        System.err.println("ERROR: " + string);
    }

    protected static void printUsage() {
        System.out.println("Generate the control flow graph of a Java method, represented as a DOT graph.");
        System.out.println("Parameters: <inputfile> <outputfile> [-method <name>] [-class <name>] [-pdf]");
        System.out.println("    -pdf:    Also generate the PDF by invoking 'dot'.");
        System.out.println("    -method: The method to generate the CFG for (defaults to 'test').");
        System.out.println("    -class:  The class in which to find the method (defaults to 'Test').");
    }

    public static void generateDOTofCFG(String inputFile, String outputFile, String method, String clas, boolean pdf) {
        JavaSource2CFGDOT.generateDOTofCFG(inputFile, outputFile, method, clas, pdf, null);
    }

    public static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> void generateDOTofCFG(String inputFile, String outputFile, String method, String clas, boolean pdf, @Nullable Analysis<A, S, T> analysis) {
        Map.Entry<MethodTree, CompilationUnitTree> m3 = JavaSource2CFGDOT.getMethodTreeAndCompilationUnit(inputFile, method, clas);
        JavaSource2CFGDOT.generateDOTofCFG(inputFile, outputFile, method, clas, pdf, analysis, m3.getKey(), m3.getValue());
    }

    public static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> void generateDOTofCFG(String inputFile, String outputFile, String method, String clas, boolean pdf, @Nullable Analysis<A, S, T> analysis, MethodTree m3, CompilationUnitTree r) {
        String fileName = new File(inputFile).getName();
        System.out.println("Working on " + fileName + "...");
        if (m3 == null) {
            JavaSource2CFGDOT.printError("Method not found.");
            System.exit(1);
        }
        ControlFlowGraph cfg = CFGBuilder.build(r, null, m3, null);
        if (analysis != null) {
            analysis.performAnalysis(cfg);
        }
        String s2 = CFGDOTVisualizer.visualize(cfg, cfg.getEntryBlock(), analysis, false);
        try {
            FileWriter fstream = new FileWriter(outputFile + ".txt");
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(s2);
            System.out.println("Finished " + fileName + ".");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (pdf) {
            JavaSource2CFGDOT.producePDF(outputFile);
        }
    }

    protected static void producePDF(String file) {
        try {
            String command = "dot -Tpdf \"" + file + ".txt\" -o \"" + file + ".pdf\"";
            Process child = Runtime.getRuntime().exec(command);
            child.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static @Nullable MethodTree getMethodTree(String file, String method, String clas) {
        return JavaSource2CFGDOT.getMethodTreeAndCompilationUnit(file, method, clas).getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map.Entry<@Nullable MethodTree, @Nullable CompilationUnitTree> getMethodTreeAndCompilationUnit(String file, final String method, String clas) {
        final Holder m3 = new Holder();
        final Holder c = new Holder();
        BasicTypeProcessor typeProcessor = new BasicTypeProcessor(){

            @Override
            protected TreePathScanner<?, ?> createTreePathScanner(CompilationUnitTree root) {
                c.value = root;
                return new TreePathScanner<Void, Void>(){

                    @Override
                    public Void visitMethod(MethodTree node, Void p) {
                        ExecutableElement el = TreeUtils.elementFromDeclaration(node);
                        if (el.getSimpleName().contentEquals(method)) {
                            m3.value = node;
                            throw new RuntimeException();
                        }
                        return null;
                    }
                };
            }
        };
        Context context = new Context();
        JavaCompiler javac = new JavaCompiler(context);
        javac.attrParseOnly = true;
        JavacFileManager fileManager = (JavacFileManager)context.get(JavaFileManager.class);
        JavaFileObject l = fileManager.getJavaFileObjectsFromStrings(List.of(file)).iterator().next();
        PrintStream err = System.err;
        try {
            System.setErr(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            }));
            javac.compile(List.of(l), List.of(clas), List.of(typeProcessor));
        }
        catch (Throwable throwable) {
        }
        finally {
            System.setErr(err);
        }
        return new Map.Entry<MethodTree, CompilationUnitTree>(){

            @Override
            public CompilationUnitTree setValue(CompilationUnitTree value) {
                return null;
            }

            @Override
            public CompilationUnitTree getValue() {
                return (CompilationUnitTree)c.value;
            }

            @Override
            public MethodTree getKey() {
                return (MethodTree)m3.value;
            }
        };
    }
}

