/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.block;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.BlockImpl;
import org.checkerframework.dataflow.cfg.block.RegularBlock;
import org.checkerframework.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.dataflow.cfg.node.Node;

public class RegularBlockImpl
extends SingleSuccessorBlockImpl
implements RegularBlock {
    protected List<Node> contents = new LinkedList<Node>();

    public RegularBlockImpl() {
        this.type = Block.BlockType.REGULAR_BLOCK;
    }

    public void addNode(Node t) {
        this.contents.add(t);
        t.setBlock(this);
    }

    public void addNodes(List<? extends Node> ts) {
        for (Node node : ts) {
            this.addNode(node);
        }
    }

    @Override
    public List<Node> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    @Override
    public BlockImpl getRegularSuccessor() {
        return this.successor;
    }

    public String toString() {
        return "RegularBlock(" + this.contents + ")";
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }
}

