/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.AssignmentContext;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;

public class ReturnNode
extends Node {
    protected ReturnTree tree;
    protected @Nullable Node result;

    public ReturnNode(ReturnTree t, @Nullable Node result, Types types, MethodTree methodTree) {
        super(types.getNoType(TypeKind.NONE));
        this.result = result;
        this.tree = t;
        result.setAssignmentContext(new AssignmentContext.MethodReturnContext(methodTree));
    }

    public ReturnNode(ReturnTree t, @Nullable Node result, Types types, LambdaExpressionTree lambda, Symbol.MethodSymbol methodSymbol) {
        super(types.getNoType(TypeKind.NONE));
        this.result = result;
        this.tree = t;
        result.setAssignmentContext(new AssignmentContext.LambdaReturnContext(methodSymbol));
    }

    public Node getResult() {
        return this.result;
    }

    @Override
    public ReturnTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitReturn(this, p);
    }

    public String toString() {
        if (this.result != null) {
            return "return " + this.result;
        }
        return "return";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ReturnNode)) {
            return false;
        }
        ReturnNode other = (ReturnNode)obj;
        if (this.result == null != (other.result == null)) {
            return false;
        }
        return this.result == null || this.result.equals(other.result);
    }

    public int hashCode() {
        return HashCodeUtils.hash((Object)this.result);
    }

    @Override
    public Collection<Node> getOperands() {
        if (this.result == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.result);
    }
}

