/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;

public class DefaultInferredTypesApplier {
    private final boolean omitSubtypingCheck;

    public DefaultInferredTypesApplier() {
        this.omitSubtypingCheck = false;
    }

    public DefaultInferredTypesApplier(boolean omitSubtypingCheck) {
        this.omitSubtypingCheck = omitSubtypingCheck;
    }

    public void applyInferredType(QualifierHierarchy qualifierHierarchy, AnnotatedTypeMirror type, AnnotatedTypeMirror inferred) {
        InferredTypeApplyingVisitor applier = new InferredTypeApplyingVisitor(qualifierHierarchy, this.omitSubtypingCheck);
        for (AnnotationMirror annotationMirror : qualifierHierarchy.getTopAnnotations()) {
            applier.visit(type, inferred, annotationMirror);
        }
    }

    protected static class InferredTypeApplyingVisitor
    extends AbstractAtmComboVisitor<Void, AnnotationMirror> {
        private final boolean omitSubtypingCheck;
        private final QualifierHierarchy qualifierHierarchy;

        public InferredTypeApplyingVisitor(QualifierHierarchy qualifierHierarchy, boolean omitSubtypingCheck) {
            this.qualifierHierarchy = qualifierHierarchy;
            this.omitSubtypingCheck = omitSubtypingCheck;
        }

        @Override
        protected String defaultErrorMessage(AnnotatedTypeMirror type, AnnotatedTypeMirror inferred, AnnotationMirror top) {
            return "applyInferredToBoundedType: Unexpected AnnotatedTypeMirror combo:\ntype=" + type + "\n" + "inferred=" + inferred + "\n" + "top=" + top + "\n";
        }

        @Override
        protected Void defaultAction(AnnotatedTypeMirror type, AnnotatedTypeMirror inferred, AnnotationMirror top) {
            AnnotationMirror inferredAnnotation = QualifierHierarchy.canHaveEmptyAnnotationSet(type) ? inferred.getAnnotationInHierarchy(top) : inferred.getEffectiveAnnotationInHierarchy(top);
            if (inferredAnnotation == null) {
                type.removeAnnotationInHierarchy(top);
            } else {
                AnnotationMirror present = type.getAnnotationInHierarchy(top);
                if (present != null) {
                    if (this.omitSubtypingCheck || this.qualifierHierarchy.isSubtype(inferredAnnotation, present)) {
                        type.replaceAnnotation(inferredAnnotation);
                    }
                } else {
                    type.addAnnotation(inferredAnnotation);
                }
            }
            return null;
        }

        @Override
        public Void visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror.AnnotatedTypeVariable inferred, AnnotationMirror top) {
            AnnotationMirror inferredPrimary = inferred.getAnnotationInHierarchy(top);
            if (inferredPrimary != null) {
                type.replaceAnnotation(inferredPrimary);
            } else {
                type.removeAnnotationInHierarchy(top);
                this.visit(type.getUpperBound(), inferred.getUpperBound(), top);
                this.visit(type.getLowerBound(), inferred.getLowerBound(), top);
            }
            return null;
        }

        @Override
        public Void visitTypevar_Wildcard(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror.AnnotatedWildcardType inferred, AnnotationMirror top) {
            AnnotationMirror inferredPrimary = inferred.getAnnotationInHierarchy(top);
            if (inferredPrimary != null) {
                type.replaceAnnotation(inferredPrimary);
            } else {
                type.removeAnnotationInHierarchy(top);
                this.visit(type.getUpperBound(), inferred.getExtendsBound(), top);
                this.visit(type.getLowerBound(), inferred.getSuperBound(), top);
            }
            return null;
        }

        @Override
        public Void visitWildcard_Typevar(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror.AnnotatedTypeVariable inferred, AnnotationMirror top) {
            AnnotationMirror inferredPrimary = inferred.getAnnotationInHierarchy(top);
            if (inferredPrimary != null) {
                this.applyPrimary(type, inferredPrimary);
            } else {
                type.removeAnnotationInHierarchy(top);
                this.visit(type.getExtendsBound(), inferred.getUpperBound(), top);
                this.visit(type.getSuperBound(), inferred.getLowerBound(), top);
            }
            return null;
        }

        @Override
        public Void visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror.AnnotatedWildcardType inferred, AnnotationMirror top) {
            AnnotationMirror inferredPrimary = inferred.getAnnotationInHierarchy(top);
            if (inferredPrimary != null) {
                this.applyPrimary(type, inferredPrimary);
            } else {
                type.removeAnnotationInHierarchy(top);
                this.visit(type.getExtendsBound(), inferred.getExtendsBound(), top);
                this.visit(type.getSuperBound(), inferred.getSuperBound(), top);
            }
            return null;
        }

        protected void applyPrimary(AnnotatedTypeMirror bound, AnnotationMirror anno) {
            if (bound != null) {
                bound.replaceAnnotation(anno);
            }
        }
    }
}

