/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.constraint;

import java.util.Set;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.typeinference.constraint.A2F;
import org.checkerframework.framework.util.typeinference.constraint.AFConstraint;
import org.checkerframework.framework.util.typeinference.constraint.AFReducer;
import org.checkerframework.framework.util.typeinference.constraint.AFReducingVisitor;
import org.checkerframework.framework.util.typeinference.constraint.F2A;
import org.checkerframework.framework.util.typeinference.constraint.FIsA;

public class F2AReducer
implements AFReducer {
    protected final F2AReducingVisitor visitor;

    public F2AReducer(AnnotatedTypeFactory typeFactory) {
        this.visitor = new F2AReducingVisitor(typeFactory);
    }

    @Override
    public boolean reduce(AFConstraint constraint, Set<AFConstraint> newConstraints) {
        if (constraint instanceof F2A) {
            F2A f2A = (F2A)constraint;
            this.visitor.visit(f2A.formalParameter, f2A.argument, newConstraints);
            return true;
        }
        return false;
    }

    class F2AReducingVisitor
    extends AFReducingVisitor {
        public F2AReducingVisitor(AnnotatedTypeFactory typeFactory) {
            super(F2A.class, typeFactory);
        }

        @Override
        public AFConstraint makeConstraint(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
            return new F2A(subtype, supertype);
        }

        @Override
        public AFConstraint makeInverseConstraint(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
            return new A2F(subtype, supertype);
        }

        @Override
        public AFConstraint makeEqualityConstraint(AnnotatedTypeMirror subtype, AnnotatedTypeMirror supertype) {
            return new FIsA(subtype, supertype);
        }
    }
}

