/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.qualframework.poly;

import org.checkerframework.qualframework.base.QualifierHierarchy;
import org.checkerframework.qualframework.poly.PolyQual;

public class PolyQualHierarchy<Q>
implements QualifierHierarchy<PolyQual<Q>> {
    private QualifierHierarchy<Q> groundHierarchy;

    public PolyQualHierarchy(QualifierHierarchy<Q> groundHierarchy) {
        this.groundHierarchy = groundHierarchy;
    }

    @Override
    public boolean isSubtype(PolyQual<Q> subtype, PolyQual<Q> supertype) {
        if (subtype.equals(supertype)) {
            return true;
        }
        Q subMax = subtype.getMaximum();
        Q superMin = supertype.getMinimum();
        return this.groundHierarchy.isSubtype(subMax, superMin);
    }

    @Override
    public PolyQual<Q> leastUpperBound(PolyQual<Q> a, PolyQual<Q> b) {
        if (this.isSubtype(a, b)) {
            return b;
        }
        if (this.isSubtype(b, a)) {
            return a;
        }
        Q aMax = a.getMaximum();
        Q bMax = b.getMaximum();
        Q groundLub = this.groundHierarchy.leastUpperBound(aMax, bMax);
        return new PolyQual.GroundQual<Q>(groundLub);
    }

    @Override
    public PolyQual<Q> greatestLowerBound(PolyQual<Q> a, PolyQual<Q> b) {
        if (this.isSubtype(a, b)) {
            return a;
        }
        if (this.isSubtype(b, a)) {
            return b;
        }
        Q aMin = a.getMinimum();
        Q bMin = b.getMinimum();
        Q groundGlb = this.groundHierarchy.greatestLowerBound(aMin, bMin);
        return new PolyQual.GroundQual<Q>(groundGlb);
    }

    @Override
    public PolyQual<Q> getTop() {
        return new PolyQual.GroundQual<Q>(this.groundHierarchy.getTop());
    }

    @Override
    public PolyQual<Q> getBottom() {
        return new PolyQual.GroundQual<Q>(this.groundHierarchy.getBottom());
    }
}

