/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.amf;

import flex.messaging.security.SecurityException;
import flex.messaging.util.PropertyStringResourceLoader;
import flex.messaging.util.ResourceLoader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.jws.WebMethod;
import org.codehaus.enunciate.modules.amf.AMFMapper;
import org.codehaus.enunciate.modules.amf.AMFMapperAware;
import org.codehaus.enunciate.modules.amf.AMFMapperIntrospector;
import org.codehaus.enunciate.modules.amf.AMFMappingContext;
import org.codehaus.enunciate.service.DefaultSecurityExceptionChecker;
import org.codehaus.enunciate.service.SecurityExceptionChecker;

public abstract class AMFEndpointImpl {
    private SecurityExceptionChecker securityChecker = new DefaultSecurityExceptionChecker();
    private final HashMap<String, Method> operationNames2Methods = new HashMap();
    protected Object serviceBean;

    protected AMFEndpointImpl(Object serviceBean) {
        this.serviceBean = serviceBean;
        this.operationNames2Methods.clear();
        for (Method method : this.getServiceInterface().getMethods()) {
            String operationName = method.getName();
            WebMethod webMethodInfo = method.getAnnotation(WebMethod.class);
            if (webMethodInfo != null && webMethodInfo.exclude()) continue;
            if (webMethodInfo != null && !"".equals(webMethodInfo.operationName())) {
                operationName = webMethodInfo.operationName();
            }
            this.operationNames2Methods.put(operationName, method);
        }
    }

    protected final Object invokeOperation(String operationName, Object ... params) throws Exception {
        Object returnValue;
        Method method = this.operationNames2Methods.get(operationName);
        if (method == null) {
            throw new NoSuchMethodError("No such method: " + operationName);
        }
        AMFMappingContext mappingContext = new AMFMappingContext();
        Type[] paramTypes = method.getGenericParameterTypes();
        if (paramTypes.length != params.length) {
            throw new IllegalArgumentException(String.format("Wrong number of parameters for operation '%s'.  Expected %s, got %s.", operationName, paramTypes.length, params.length));
        }
        Object[] mappedParams = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            AMFMapper mapper = params[i] instanceof AMFMapperAware ? ((AMFMapperAware)params[i]).loadAMFMapper() : AMFMapperIntrospector.getAMFMapper(paramTypes[i]);
            mappedParams[i] = mapper.toJAXB(params[i], mappingContext);
        }
        try {
            returnValue = method.invoke(this.serviceBean, mappedParams);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (this.securityChecker.isAuthenticationFailed(targetException) || this.securityChecker.isAccessDenied(targetException)) {
                SecurityException se = new SecurityException((ResourceLoader)new PropertyStringResourceLoader("flex.messaging.vendors"));
                se.setMessage(targetException.getMessage());
                throw se;
            }
            for (int i = 0; i < method.getExceptionTypes().length; ++i) {
                Class<?> exceptionType = method.getExceptionTypes()[i];
                if (!exceptionType.isInstance(targetException)) continue;
                throw (Exception)AMFMapperIntrospector.getAMFMapper(targetException.getClass(), exceptionType).toAMF(targetException, mappingContext);
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw (Exception)targetException;
        }
        if (method.getReturnType() != Void.TYPE) {
            returnValue = returnValue != null ? AMFMapperIntrospector.getAMFMapper(returnValue.getClass(), method.getGenericReturnType()).toAMF(returnValue, mappingContext) : null;
        }
        return returnValue;
    }

    public void setSecurityChecker(SecurityExceptionChecker securityChecker) {
        this.securityChecker = securityChecker;
    }

    protected abstract Class getServiceInterface();
}

