/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.amf;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.codehaus.enunciate.modules.amf.AMFMapper;
import org.codehaus.enunciate.modules.amf.AMFMappingException;
import org.codehaus.enunciate.modules.amf.AdaptingAMFMapper;
import org.codehaus.enunciate.modules.amf.ArrayAMFMapper;
import org.codehaus.enunciate.modules.amf.CollectionAMFMapper;
import org.codehaus.enunciate.modules.amf.DataHandlerAMFMapper;
import org.codehaus.enunciate.modules.amf.DefaultAMFMapper;
import org.codehaus.enunciate.modules.amf.EnumAMFMapper;
import org.codehaus.enunciate.modules.amf.MapAMFMapper;
import org.codehaus.enunciate.modules.amf.QNameAMFMapper;
import org.codehaus.enunciate.modules.amf.URIAMFMapper;
import org.codehaus.enunciate.modules.amf.UUIDAMFMapper;
import org.codehaus.enunciate.modules.amf.XMLGregorianCalendarAMFMapper;

public class AMFMapperIntrospector {
    private static final Map<Type, AMFMapper> MAPPERS = new HashMap<Type, AMFMapper>();

    public static AMFMapper getAMFMapper(Type jaxbType) {
        return AMFMapperIntrospector.getAMFMapper(null, jaxbType);
    }

    public static AMFMapper getAMFMapper(Class realType, Type jaxbType) {
        return AMFMapperIntrospector.getAMFMapper(realType, jaxbType, null, null);
    }

    public static AMFMapper getAMFMapper(Type jaxbType, XmlJavaTypeAdapter adapterInfo, XmlElement elementInfo) {
        return AMFMapperIntrospector.getAMFMapper(null, jaxbType, adapterInfo, elementInfo);
    }

    public static AMFMapper getAMFMapper(Class realType, Type jaxbType, XmlJavaTypeAdapter adapterInfo, XmlElement elementInfo) {
        AMFMapper mapper;
        Class specifiedType;
        if (adapterInfo == null && realType != null && !realType.isArray() && !realType.isPrimitive() && realType.getPackage() != null) {
            if (MAPPERS.containsKey(realType)) {
                return MAPPERS.get(realType);
            }
            try {
                AMFMapperIntrospector.loadCustomMapperClass(realType);
                jaxbType = realType;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (adapterInfo == null && jaxbType instanceof Class) {
            adapterInfo = ((Class)jaxbType).getAnnotation(XmlJavaTypeAdapter.class);
        }
        if (adapterInfo != null) {
            Type adaptingType = AMFMapperIntrospector.findAdaptingType(adapterInfo.value());
            AMFMapper adaptingMapper = AMFMapperIntrospector.getAMFMapper(adaptingType);
            AMFMapper adaptedMapper = AMFMapperIntrospector.getAMFMapper((Type)jaxbType);
            try {
                return new AdaptingAMFMapper((XmlAdapter)adapterInfo.value().newInstance(), adaptingMapper, adaptedMapper, AMFMapperIntrospector.narrowType((Type)jaxbType), AMFMapperIntrospector.narrowType(adaptingType));
            }
            catch (Exception e) {
                throw new AMFMappingException(e);
            }
        }
        if (jaxbType == null) {
            jaxbType = Object.class;
        }
        Class clazz = specifiedType = elementInfo != null && elementInfo.type() != null && elementInfo.type() != XmlElement.DEFAULT.class ? elementInfo.type() : null;
        if (adapterInfo == null && MAPPERS.containsKey(jaxbType)) {
            mapper = MAPPERS.get(jaxbType);
        } else {
            if (jaxbType instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)jaxbType).getRawType();
                if (rawType instanceof Class) {
                    if (Map.class.isAssignableFrom((Class)rawType)) {
                        Object keyType = Object.class;
                        Object valueType = Object.class;
                        Type[] typeArgs = ((ParameterizedType)jaxbType).getActualTypeArguments();
                        if (typeArgs != null && typeArgs.length == 2) {
                            keyType = typeArgs[0];
                            valueType = typeArgs[1];
                        }
                        mapper = new MapAMFMapper((Class)rawType, (Type)keyType, (Type)valueType, adapterInfo);
                    } else if (Collection.class.isAssignableFrom((Class)rawType)) {
                        Type itemType = Object.class;
                        Type[] typeArgs = ((ParameterizedType)jaxbType).getActualTypeArguments();
                        if (specifiedType != null) {
                            itemType = specifiedType;
                        } else if (typeArgs != null && typeArgs.length == 1) {
                            itemType = typeArgs[0];
                        }
                        mapper = new CollectionAMFMapper((Class)rawType, itemType, adapterInfo, null);
                    } else {
                        mapper = AMFMapperIntrospector.getAMFMapper(rawType, adapterInfo, elementInfo);
                    }
                } else {
                    mapper = AMFMapperIntrospector.getAMFMapper(rawType, adapterInfo, elementInfo);
                }
            } else if (jaxbType instanceof GenericArrayType) {
                mapper = new ArrayAMFMapper(((GenericArrayType)jaxbType).getGenericComponentType(), adapterInfo, elementInfo);
            } else if (jaxbType instanceof TypeVariable) {
                mapper = AMFMapperIntrospector.getAMFMapper(((TypeVariable)jaxbType).getBounds()[0], adapterInfo, elementInfo);
            } else if (jaxbType instanceof WildcardType) {
                mapper = AMFMapperIntrospector.getAMFMapper(((WildcardType)jaxbType).getUpperBounds()[0], adapterInfo, elementInfo);
            } else if (jaxbType instanceof Class) {
                Class jaxbClass = (Class)jaxbType;
                if (jaxbClass.isArray()) {
                    mapper = jaxbClass.getComponentType().isPrimitive() ? DefaultAMFMapper.INSTANCE : new ArrayAMFMapper(jaxbClass.getComponentType(), adapterInfo, elementInfo);
                } else if (Collection.class.isAssignableFrom(jaxbClass)) {
                    mapper = specifiedType != null ? new CollectionAMFMapper(jaxbClass, specifiedType, adapterInfo, null) : new CollectionAMFMapper(jaxbClass, (Type)((Object)Object.class), null, null);
                } else if (Map.class.isAssignableFrom(jaxbClass)) {
                    mapper = new MapAMFMapper(jaxbClass, (Type)((Object)Object.class), (Type)((Object)Object.class), null);
                } else if (specifiedType != null) {
                    mapper = AMFMapperIntrospector.getAMFMapper(specifiedType);
                } else if (Enum.class.isAssignableFrom(jaxbClass)) {
                    mapper = new EnumAMFMapper(jaxbClass);
                } else if (jaxbClass.isPrimitive()) {
                    mapper = DefaultAMFMapper.INSTANCE;
                } else {
                    try {
                        mapper = AMFMapperIntrospector.loadCustomMapperClass(jaxbClass).newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        mapper = DefaultAMFMapper.INSTANCE;
                    }
                    catch (NoClassDefFoundError e) {
                        mapper = DefaultAMFMapper.INSTANCE;
                    }
                    catch (Throwable e) {
                        throw new AMFMappingException("Unable to instantiate class '" + jaxbClass.getPackage().getName() + ".amf." + jaxbClass.getSimpleName() + "AMFMapper'.", e);
                    }
                }
            } else {
                mapper = DefaultAMFMapper.INSTANCE;
            }
            if (specifiedType == null) {
                MAPPERS.put((Type)jaxbType, mapper);
            }
        }
        return mapper;
    }

    public static Class narrowType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return AMFMapperIntrospector.narrowType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(AMFMapperIntrospector.narrowType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return AMFMapperIntrospector.narrowType(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return AMFMapperIntrospector.narrowType(((WildcardType)type).getUpperBounds()[0]);
        }
        throw new IllegalArgumentException("Unsupported Type type: " + type);
    }

    private static Class<? extends AMFMapper> loadCustomMapperClass(Class jaxbClass) throws ClassNotFoundException {
        if (jaxbClass.getPackage().getName().startsWith("java.")) {
            throw new ClassNotFoundException();
        }
        if (jaxbClass.getPackage().getName().startsWith("javax.")) {
            throw new ClassNotFoundException();
        }
        return Class.forName(jaxbClass.getPackage().getName() + ".amf." + jaxbClass.getSimpleName() + "AMFMapper");
    }

    private static Type findAdaptingType(Class<? extends XmlAdapter> adapterClass) {
        Type superClass = adapterClass.getGenericSuperclass();
        if (superClass instanceof ParameterizedType && ((ParameterizedType)superClass).getRawType() instanceof Class && XmlAdapter.class.isAssignableFrom((Class)((ParameterizedType)superClass).getRawType())) {
            return ((ParameterizedType)superClass).getActualTypeArguments()[0];
        }
        if (XmlAdapter.class.isAssignableFrom(adapterClass.getSuperclass())) {
            return AMFMapperIntrospector.findAdaptingType(adapterClass.getSuperclass());
        }
        throw new IllegalStateException("Unable to find the adapting type for xml adapter " + adapterClass.getName());
    }

    private AMFMapperIntrospector() {
    }

    static {
        MAPPERS.put((Type)((Object)DataHandler.class), new DataHandlerAMFMapper());
        MAPPERS.put((Type)((Object)QName.class), new QNameAMFMapper());
        MAPPERS.put((Type)((Object)URI.class), new URIAMFMapper());
        MAPPERS.put((Type)((Object)UUID.class), new UUIDAMFMapper());
        MAPPERS.put((Type)((Object)XMLGregorianCalendar.class), new XMLGregorianCalendarAMFMapper());
    }
}

