/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.amf;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.codehaus.enunciate.modules.amf.AMFMapper;
import org.codehaus.enunciate.modules.amf.AMFMappingContext;
import org.codehaus.enunciate.modules.amf.AMFMappingException;
import org.codehaus.enunciate.modules.amf.CustomAMFMapper;

public class AdaptingAMFMapper
implements CustomAMFMapper {
    private final XmlAdapter adapter;
    private final AMFMapper adaptingMapper;
    private final AMFMapper adaptedMapper;
    private final Class jaxbClass;
    private final Class amfClass;

    public AdaptingAMFMapper(XmlAdapter adapter, AMFMapper adaptingMapper, AMFMapper adaptedMapper, Class jaxbClass, Class amfClass) {
        this.adapter = adapter;
        this.adaptingMapper = adaptingMapper;
        this.adaptedMapper = adaptedMapper;
        this.jaxbClass = jaxbClass;
        this.amfClass = amfClass;
    }

    @Override
    public Object toAMF(Object jaxbObject, AMFMappingContext context) throws AMFMappingException {
        try {
            return this.adaptingMapper.toAMF(this.adapter.marshal(this.adaptedMapper.toAMF(jaxbObject, context)), context);
        }
        catch (Exception e) {
            throw new AMFMappingException(e);
        }
    }

    @Override
    public Object toJAXB(Object amfObject, AMFMappingContext context) throws AMFMappingException {
        try {
            return this.adaptedMapper.toJAXB(this.adapter.unmarshal(this.adaptingMapper.toJAXB(amfObject, context)), context);
        }
        catch (Exception e) {
            throw new AMFMappingException(e);
        }
    }

    public Class getJaxbClass() {
        return this.jaxbClass;
    }

    public Class getAmfClass() {
        return this.amfClass;
    }
}

