/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.amf;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.enunciate.modules.amf.AMFMapper;
import org.codehaus.enunciate.modules.amf.AMFMapperAware;
import org.codehaus.enunciate.modules.amf.AMFMapperIntrospector;
import org.codehaus.enunciate.modules.amf.AMFMappingContext;
import org.codehaus.enunciate.modules.amf.AMFMappingException;
import org.codehaus.enunciate.modules.amf.CustomAMFMapper;

public class ArrayAMFMapper
implements CustomAMFMapper {
    private final Type declaredComponentType;
    private final Class jaxbItemClass;
    private final Class amfItemClass;
    private final XmlJavaTypeAdapter adapterInfo;
    private final XmlElement elementInfo;

    public ArrayAMFMapper(Type declaredComponentType, XmlJavaTypeAdapter adapterInfo, XmlElement elementInfo) {
        this.declaredComponentType = declaredComponentType;
        this.adapterInfo = adapterInfo;
        this.elementInfo = elementInfo;
        this.jaxbItemClass = AMFMapperIntrospector.narrowType(this.declaredComponentType);
        AMFMapper defaultMapper = AMFMapperIntrospector.getAMFMapper(this.declaredComponentType, adapterInfo, elementInfo);
        this.amfItemClass = defaultMapper instanceof CustomAMFMapper ? ((CustomAMFMapper)defaultMapper).getAmfClass() : this.jaxbItemClass;
    }

    @Override
    public Object toAMF(Object jaxbObject, AMFMappingContext context) throws AMFMappingException {
        if (jaxbObject == null) {
            return null;
        }
        Object[] jaxbArray = (Object[])jaxbObject;
        Object[] amfArray = (Object[])Array.newInstance(this.amfItemClass, jaxbArray.length);
        for (int i = 0; i < jaxbArray.length; ++i) {
            Object amfItem;
            Object jaxbItem = jaxbArray[i];
            if (jaxbItem == null) {
                amfItem = null;
            } else {
                AMFMapper itemMapper = AMFMapperIntrospector.getAMFMapper(jaxbItem.getClass(), this.declaredComponentType, this.adapterInfo, this.elementInfo);
                amfItem = itemMapper.toAMF(jaxbItem, context);
            }
            amfArray[i] = amfItem;
        }
        return amfArray;
    }

    @Override
    public Object toJAXB(Object amfObject, AMFMappingContext context) throws AMFMappingException {
        if (amfObject == null) {
            return null;
        }
        Object[] amfArray = (Object[])amfObject;
        Object[] jaxbArray = (Object[])Array.newInstance(this.jaxbItemClass, amfArray.length);
        for (int i = 0; i < amfArray.length; ++i) {
            Object jaxbItem;
            Object amfItem = amfArray[i];
            if (amfItem == null) {
                jaxbItem = null;
            } else {
                AMFMapper itemMapper = amfItem instanceof AMFMapperAware ? ((AMFMapperAware)amfItem).loadAMFMapper() : AMFMapperIntrospector.getAMFMapper(this.declaredComponentType, this.adapterInfo, this.elementInfo);
                jaxbItem = itemMapper.toJAXB(amfItem, context);
            }
            jaxbArray[i] = jaxbItem;
        }
        return jaxbArray;
    }

    public Class getJaxbClass() {
        return Array.newInstance(this.jaxbItemClass, 0).getClass();
    }

    public Class getAmfClass() {
        return Array.newInstance(this.amfItemClass, 0).getClass();
    }
}

