/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.amf;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import org.codehaus.enunciate.modules.amf.AMFMapper;
import org.codehaus.enunciate.modules.amf.AMFMapperAware;
import org.codehaus.enunciate.modules.amf.AMFMapperIntrospector;
import org.codehaus.enunciate.modules.amf.AMFMappingContext;
import org.codehaus.enunciate.modules.amf.AMFMappingException;
import org.codehaus.enunciate.modules.amf.CustomAMFMapper;

public abstract class BaseAMFMapper<J, G>
implements CustomAMFMapper<J, G> {
    private final Class<J> jaxbClass;
    private final Class<G> amfClass;
    private final String[] properties;
    private final PropertyDescriptor[][] jaxbProperties2amfProperties;

    protected BaseAMFMapper(Class<J> jaxbClass, Class<G> amfClass, String ... properties) {
        this.jaxbClass = jaxbClass;
        this.amfClass = amfClass;
        if (properties == null) {
            properties = new String[]{};
        }
        this.properties = properties;
        this.jaxbProperties2amfProperties = new PropertyDescriptor[this.properties.length][];
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            PropertyDescriptor jaxbProperty = this.findProperty(jaxbClass, property);
            if (jaxbProperty == null) {
                throw new IllegalStateException("Unknown property '" + property + "' on class " + jaxbClass.getName() + ".");
            }
            PropertyDescriptor amfProperty = this.findProperty(amfClass, property);
            if (amfProperty == null) {
                throw new IllegalStateException("Unknown property '" + property + "' on class " + amfClass.getName() + ".");
            }
            this.jaxbProperties2amfProperties[i] = new PropertyDescriptor[]{jaxbProperty, amfProperty};
        }
    }

    protected PropertyDescriptor findProperty(Class clazz, String property) {
        PropertyDescriptor[] pds;
        BeanInfo beanInfo;
        if (Object.class.equals((Object)clazz)) {
            return null;
        }
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals(property)) continue;
            return pd;
        }
        return this.findProperty(clazz.getSuperclass(), property);
    }

    @Override
    public G toAMF(J jaxbObject, AMFMappingContext context) throws AMFMappingException {
        G amfObject;
        if (jaxbObject == null) {
            return null;
        }
        if (context.getMappedObjects().containsKey(jaxbObject)) {
            return (G)context.getMappedObjects().get(jaxbObject);
        }
        try {
            amfObject = this.amfClass.newInstance();
        }
        catch (Exception e) {
            throw new AMFMappingException("Unable to instantiate an instance AMF class " + this.amfClass.getName() + ".", e);
        }
        context.objectMapped(jaxbObject, amfObject);
        for (PropertyDescriptor[] pds : this.jaxbProperties2amfProperties) {
            Object propertyValue;
            PropertyDescriptor jaxbProperty = pds[0];
            PropertyDescriptor amfProperty = pds[1];
            Method getter = jaxbProperty.getReadMethod();
            if (getter == null) {
                throw new AMFMappingException("In order to convert from JAXB classes to AMF, you must provide a getter for property '" + jaxbProperty.getName() + "' on class " + jaxbProperty.getWriteMethod().getDeclaringClass());
            }
            try {
                propertyValue = getter.invoke(jaxbObject, new Object[0]);
            }
            catch (Exception e) {
                throw new AMFMappingException("Unable to read property '" + jaxbProperty.getName() + "' on " + jaxbObject, e);
            }
            if (propertyValue == null) continue;
            XmlJavaTypeAdapter adapterInfo = this.findTypeAdapter(jaxbProperty);
            XmlElement xmlElement = this.findXmlElement(jaxbProperty);
            AMFMapper mapper = AMFMapperIntrospector.getAMFMapper(propertyValue.getClass(), getter.getGenericReturnType(), adapterInfo, xmlElement);
            try {
                amfProperty.getWriteMethod().invoke(amfObject, mapper.toAMF(propertyValue, context));
            }
            catch (Exception e) {
                throw new AMFMappingException("Unable to set property " + jaxbProperty.getName() + " for the amf bean " + this.amfClass.getName(), e);
            }
        }
        return amfObject;
    }

    private XmlJavaTypeAdapter findTypeAdapter(PropertyDescriptor jaxbProperty) {
        XmlJavaTypeAdapter adapterInfo = null;
        if (jaxbProperty.getReadMethod() != null) {
            adapterInfo = jaxbProperty.getReadMethod().getAnnotation(XmlJavaTypeAdapter.class);
        }
        if (adapterInfo == null && jaxbProperty.getWriteMethod() != null) {
            adapterInfo = jaxbProperty.getWriteMethod().getAnnotation(XmlJavaTypeAdapter.class);
        }
        if (adapterInfo == null) {
            Package pckg = jaxbProperty.getReadMethod().getDeclaringClass().getPackage();
            Class<?> returnType = jaxbProperty.getReadMethod().getReturnType();
            XmlJavaTypeAdapter possibleAdapterInfo = pckg.getAnnotation(XmlJavaTypeAdapter.class);
            if (possibleAdapterInfo != null && returnType.equals(possibleAdapterInfo.type())) {
                adapterInfo = possibleAdapterInfo;
            } else if (pckg.isAnnotationPresent(XmlJavaTypeAdapters.class)) {
                XmlJavaTypeAdapters adapters = pckg.getAnnotation(XmlJavaTypeAdapters.class);
                for (XmlJavaTypeAdapter possibility : adapters.value()) {
                    if (!returnType.equals(possibility.type())) continue;
                    adapterInfo = possibility;
                }
            }
        }
        return adapterInfo;
    }

    private XmlElement findXmlElement(PropertyDescriptor property) {
        XmlElement xmlElement = null;
        if (property.getReadMethod() != null) {
            xmlElement = property.getReadMethod().getAnnotation(XmlElement.class);
        }
        if (xmlElement == null && property.getWriteMethod() != null) {
            xmlElement = property.getWriteMethod().getAnnotation(XmlElement.class);
        }
        return xmlElement;
    }

    @Override
    public J toJAXB(G amfObject, AMFMappingContext context) throws AMFMappingException {
        J jaxbObject;
        if (amfObject == null) {
            return null;
        }
        if (context.getMappedObjects().containsKey(amfObject)) {
            return (J)context.getMappedObjects().get(amfObject);
        }
        try {
            jaxbObject = this.jaxbClass.newInstance();
        }
        catch (Exception e) {
            throw new AMFMappingException("Unable to instantiate an instance JAXB class " + this.jaxbClass.getName() + ".", e);
        }
        context.objectMapped(amfObject, jaxbObject);
        for (PropertyDescriptor[] pds : this.jaxbProperties2amfProperties) {
            Object propertyValue;
            PropertyDescriptor jaxbProperty = pds[0];
            PropertyDescriptor amfProperty = pds[1];
            Method getter = amfProperty.getReadMethod();
            try {
                propertyValue = getter.invoke(amfObject, new Object[0]);
            }
            catch (Exception e) {
                throw new AMFMappingException("Unable to read property '" + amfProperty.getName() + "' on " + amfObject, e);
            }
            if (propertyValue == null) continue;
            Method setter = jaxbProperty.getWriteMethod();
            if (setter == null) {
                throw new AMFMappingException("In order to convert from AMF back to JAXB classes, you must provide a setter for property '" + jaxbProperty.getName() + "' on class " + jaxbProperty.getReadMethod().getDeclaringClass());
            }
            XmlJavaTypeAdapter typeAdapter = this.findTypeAdapter(jaxbProperty);
            AMFMapper mapper = propertyValue instanceof AMFMapperAware && typeAdapter == null ? ((AMFMapperAware)propertyValue).loadAMFMapper() : AMFMapperIntrospector.getAMFMapper(setter.getGenericParameterTypes()[0], typeAdapter, this.findXmlElement(jaxbProperty));
            try {
                setter.invoke(jaxbObject, mapper.toJAXB(propertyValue, context));
            }
            catch (Exception e) {
                throw new AMFMappingException("Unable to set property " + jaxbProperty.getName() + " for the amf bean " + this.amfClass.getName(), e);
            }
        }
        return jaxbObject;
    }

    public static String[] append(String[] args1, String ... args2) {
        String[] allArgs = new String[args1.length + args2.length];
        System.arraycopy(args2, 0, allArgs, 0, args2.length);
        System.arraycopy(args1, 0, allArgs, args2.length, args1.length);
        return allArgs;
    }

    @Override
    public Class<J> getJaxbClass() {
        return this.jaxbClass;
    }

    @Override
    public Class<G> getAmfClass() {
        return this.amfClass;
    }
}

