/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.amf;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.enunciate.modules.amf.AMFMapper;
import org.codehaus.enunciate.modules.amf.AMFMapperAware;
import org.codehaus.enunciate.modules.amf.AMFMapperIntrospector;
import org.codehaus.enunciate.modules.amf.AMFMappingContext;
import org.codehaus.enunciate.modules.amf.AMFMappingException;

public class CollectionAMFMapper
implements AMFMapper<Collection, Collection> {
    private final Class<? extends Collection> collectionType;
    private final Type defaultItemType;
    private final XmlJavaTypeAdapter adapterInfo;
    private final XmlElement elementInfo;

    public CollectionAMFMapper(Class<? extends Collection> collectionType, Type defaultItemType, XmlJavaTypeAdapter adapterInfo, XmlElement elementInfo) {
        this.collectionType = collectionType;
        this.defaultItemType = defaultItemType;
        this.adapterInfo = adapterInfo;
        this.elementInfo = elementInfo;
    }

    @Override
    public Collection toAMF(Collection jaxbObject, AMFMappingContext context) throws AMFMappingException {
        if (jaxbObject == null) {
            return null;
        }
        Collection collection = CollectionAMFMapper.newCollectionInstance(this.collectionType);
        for (Object item : jaxbObject) {
            Object toItem = item != null ? (Object)AMFMapperIntrospector.getAMFMapper(item.getClass(), this.defaultItemType, this.adapterInfo, this.elementInfo).toAMF(item, context) : null;
            collection.add(toItem);
        }
        return collection;
    }

    @Override
    public Collection toJAXB(Collection amfObject, AMFMappingContext context) throws AMFMappingException {
        if (amfObject == null) {
            return null;
        }
        Collection collection = CollectionAMFMapper.newCollectionInstance(this.collectionType);
        for (Object item : amfObject) {
            AMFMapper itemMapper = item instanceof AMFMapperAware ? ((AMFMapperAware)item).loadAMFMapper() : AMFMapperIntrospector.getAMFMapper(this.defaultItemType, this.adapterInfo, this.elementInfo);
            collection.add(itemMapper.toJAXB(item, context));
        }
        return collection;
    }

    public static Collection newCollectionInstance(Class collectionType) {
        if (Collection.class.isAssignableFrom(collectionType)) {
            Collection collection;
            if (collectionType.isInterface() || Modifier.isAbstract(collectionType.getModifiers())) {
                collection = Set.class.isAssignableFrom(collectionType) ? (SortedSet.class.isAssignableFrom(collectionType) ? new TreeSet() : new HashSet()) : new ArrayList();
            } else {
                try {
                    collection = (Collection)collectionType.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to create an instance of " + collectionType.getName() + ".", e);
                }
            }
            return collection;
        }
        throw new IllegalArgumentException("Invalid list type: " + collectionType.getName());
    }
}

