/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.amf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.codehaus.enunciate.modules.amf.AMFMappingContext;
import org.codehaus.enunciate.modules.amf.AMFMappingException;
import org.codehaus.enunciate.modules.amf.CustomAMFMapper;

public class DataHandlerAMFMapper
implements CustomAMFMapper<DataHandler, byte[]> {
    @Override
    public byte[] toAMF(DataHandler jaxbObject, AMFMappingContext context) throws AMFMappingException {
        if (jaxbObject == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            jaxbObject.writeTo((OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            throw new AMFMappingException(e);
        }
        return out.toByteArray();
    }

    @Override
    public DataHandler toJAXB(final byte[] amfObject, AMFMappingContext context) throws AMFMappingException {
        if (amfObject == null) {
            return null;
        }
        return new DataHandler(new DataSource(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(amfObject);
            }

            public OutputStream getOutputStream() throws IOException {
                throw new IOException();
            }

            public String getContentType() {
                return "application/octet-stream";
            }

            public String getName() {
                return "";
            }
        });
    }

    @Override
    public Class<? extends DataHandler> getJaxbClass() {
        return DataHandler.class;
    }

    @Override
    public Class<? extends byte[]> getAmfClass() {
        return byte[].class;
    }
}

