/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.amf;

import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.Amf3Input;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.codehaus.enunciate.modules.amf.AMFDataReader;
import org.codehaus.enunciate.modules.amf.AMFMapper;
import org.codehaus.enunciate.modules.amf.AMFMapperIntrospector;
import org.codehaus.enunciate.modules.amf.AMFMappingContext;
import org.codehaus.enunciate.modules.amf.CollectionAMFMapper;
import org.codehaus.enunciate.modules.amf.CustomAMFMapper;
import org.codehaus.enunciate.modules.amf.MapAMFMapper;

public class EnunciateAMFDataReader
implements AMFDataReader {
    @Override
    public boolean isReadable(Class realType, Type genericType) {
        AMFMapper mapper = AMFMapperIntrospector.getAMFMapper(realType, genericType);
        if (mapper instanceof CustomAMFMapper) {
            return realType.isAssignableFrom(((CustomAMFMapper)mapper).getJaxbClass());
        }
        return mapper instanceof CollectionAMFMapper || mapper instanceof MapAMFMapper;
    }

    @Override
    public Object readFrom(Class realType, Type genericType, InputStream stream) throws IOException {
        AMFMapper mapper = AMFMapperIntrospector.getAMFMapper(realType, genericType);
        SerializationContext context = new SerializationContext();
        Amf3Input input = new Amf3Input(context);
        input.setInputStream(stream);
        try {
            return mapper.toJAXB(input.readObject(), new AMFMappingContext());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Invalid request: " + e.getMessage());
        }
    }
}

