/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.amf;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.enunciate.modules.amf.AMFMapper;
import org.codehaus.enunciate.modules.amf.AMFMapperAware;
import org.codehaus.enunciate.modules.amf.AMFMapperIntrospector;
import org.codehaus.enunciate.modules.amf.AMFMappingContext;
import org.codehaus.enunciate.modules.amf.AMFMappingException;

public class MapAMFMapper
implements AMFMapper<Map, Map> {
    private final Class<Map> mapType;
    private final Type keyType;
    private final Type valueType;
    private final XmlJavaTypeAdapter adapterInfo;

    public MapAMFMapper(Class<Map> mapType, Type keyType, Type valueType, XmlJavaTypeAdapter adapterInfo) {
        this.mapType = mapType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.adapterInfo = adapterInfo;
    }

    @Override
    public Map toAMF(Map jaxbObject, AMFMappingContext context) throws AMFMappingException {
        if (jaxbObject == null) {
            return null;
        }
        Map map = MapAMFMapper.getMapInstance(this.mapType);
        for (Map.Entry entry : jaxbObject.entrySet()) {
            Object jaxbKey = entry.getKey();
            Object jaxbValue = entry.getValue();
            Object amfKey = jaxbKey != null ? (Object)AMFMapperIntrospector.getAMFMapper(jaxbKey.getClass(), this.keyType, this.adapterInfo, null).toAMF(jaxbKey, context) : null;
            Object amfValue = jaxbValue != null ? (Object)AMFMapperIntrospector.getAMFMapper(jaxbValue.getClass(), this.valueType, this.adapterInfo, null).toAMF(jaxbValue, context) : null;
            map.put(amfKey, amfValue);
        }
        return map;
    }

    @Override
    public Map toJAXB(Map amfObject, AMFMappingContext context) throws AMFMappingException {
        if (amfObject == null) {
            return null;
        }
        Map map = MapAMFMapper.getMapInstance(this.mapType);
        for (Map.Entry entry : amfObject.entrySet()) {
            Object amfKey = entry.getKey();
            Object amfValue = entry.getValue();
            AMFMapper keyMapper = amfKey instanceof AMFMapperAware ? ((AMFMapperAware)amfKey).loadAMFMapper() : AMFMapperIntrospector.getAMFMapper(this.keyType, this.adapterInfo, null);
            AMFMapper valueMapper = amfValue instanceof AMFMapperAware ? ((AMFMapperAware)amfValue).loadAMFMapper() : AMFMapperIntrospector.getAMFMapper(this.valueType, this.adapterInfo, null);
            Object jaxbKey = keyMapper.toJAXB(amfKey, context);
            Object jaxbValue = valueMapper.toJAXB(amfValue, context);
            map.put(jaxbKey, jaxbValue);
        }
        return map;
    }

    public static Map getMapInstance(Class<Map> mapType) {
        Map map;
        if (mapType.isInterface() || Modifier.isAbstract(mapType.getModifiers())) {
            map = new HashMap();
        } else {
            try {
                map = mapType.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create an instance of " + mapType.getName() + ".", e);
            }
        }
        return map;
    }
}

