/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.amf;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.codehaus.enunciate.modules.amf.AMFMappingContext;
import org.codehaus.enunciate.modules.amf.AMFMappingException;
import org.codehaus.enunciate.modules.amf.CustomAMFMapper;

public class XMLGregorianCalendarAMFMapper
implements CustomAMFMapper<XMLGregorianCalendar, Date> {
    @Override
    public Date toAMF(XMLGregorianCalendar jaxbObject, AMFMappingContext context) throws AMFMappingException {
        return jaxbObject == null ? null : jaxbObject.toGregorianCalendar().getTime();
    }

    @Override
    public XMLGregorianCalendar toJAXB(Date amfObject, AMFMappingContext context) throws AMFMappingException {
        if (amfObject == null) {
            return null;
        }
        try {
            GregorianCalendar gregorianCal = new GregorianCalendar();
            gregorianCal.setTime(amfObject);
            DatatypeFactory factory = DatatypeFactory.newInstance();
            return factory.newXMLGregorianCalendar(gregorianCal);
        }
        catch (DatatypeConfigurationException e) {
            throw new AMFMappingException("Internal Error mapping from AMF to an instance of XMLGregorianCalendar: ", e);
        }
    }

    @Override
    public Class<? extends XMLGregorianCalendar> getJaxbClass() {
        return XMLGregorianCalendar.class;
    }

    @Override
    public Class<? extends Date> getAmfClass() {
        return Date.class;
    }
}

