/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.c;

import com.sun.mirror.declaration.ClassDeclaration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.freemarker.FreemarkerJavaDoc;
import org.apache.commons.digester.RuleSet;
import org.codehaus.enunciate.EnunciateException;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.config.SchemaInfo;
import org.codehaus.enunciate.contract.jaxb.ElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.LocalElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.RootElementDeclaration;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.ArtifactType;
import org.codehaus.enunciate.main.ClientLibraryArtifact;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.main.NamedFileArtifact;
import org.codehaus.enunciate.modules.FacetAware;
import org.codehaus.enunciate.modules.FreemarkerDeploymentModule;
import org.codehaus.enunciate.modules.c.CValidator;
import org.codehaus.enunciate.modules.c.ClientClassnameForMethod;
import org.codehaus.enunciate.modules.c.NameForEnumConstantMethod;
import org.codehaus.enunciate.modules.c.NameForTypeDefinitionMethod;
import org.codehaus.enunciate.modules.c.PrefixMethod;
import org.codehaus.enunciate.modules.c.XmlFunctionIdentifierMethod;
import org.codehaus.enunciate.modules.c.config.CRuleSet;
import org.codehaus.enunciate.template.freemarker.AccessorOverridesAnotherMethod;
import org.codehaus.enunciate.template.freemarker.FindRootElementMethod;
import org.codehaus.enunciate.template.freemarker.ReferencedNamespacesMethod;

public class CDeploymentModule
extends FreemarkerDeploymentModule
implements FacetAware {
    private static final Pattern SCRUB_PATTERN = Pattern.compile("\\W");
    private boolean forceEnable = false;
    private String label = null;
    private String typeDefinitionNamePattern = "%1$s_%2$s_%3$s";
    private String enumConstantNamePattern = "%1$S_%2$S_%3$S_%9$S";
    private boolean separateCommonCode = true;
    private Set<String> facetIncludes = new TreeSet<String>();
    private Set<String> facetExcludes = new TreeSet<String>();

    public String getName() {
        return "c";
    }

    public static String scrubIdentifier(String identifier) {
        return identifier == null ? null : SCRUB_PATTERN.matcher(identifier).replaceAll("_");
    }

    public void doFreemarkerGenerate() throws IOException, TemplateException, EnunciateException {
        File genDir = this.getGenerateDir();
        if (!this.enunciate.isUpToDateWithSources(genDir)) {
            EnunciateFreemarkerModel model = this.getModel();
            String label = this.getLabel() == null ? (this.getEnunciate().getConfig() == null ? "enunciate" : this.getEnunciate().getConfig().getLabel()) : this.getLabel();
            NameForTypeDefinitionMethod nameForTypeDefinition = new NameForTypeDefinitionMethod(this.getTypeDefinitionNamePattern(), label, model.getNamespacesToPrefixes());
            model.put("nameForTypeDefinition", (Object)nameForTypeDefinition);
            model.put("nameForEnumConstant", (Object)new NameForEnumConstantMethod(this.getEnumConstantNamePattern(), label, model.getNamespacesToPrefixes()));
            TreeMap<String, String> conversions = new TreeMap<String, String>();
            for (SchemaInfo schemaInfo : model.getNamespacesToSchemas().values()) {
                for (TypeDefinition typeDefinition : schemaInfo.getTypeDefinitions()) {
                    if (typeDefinition.isEnum()) {
                        conversions.put(typeDefinition.getQualifiedName(), "enum " + nameForTypeDefinition.calculateName(typeDefinition));
                        continue;
                    }
                    conversions.put(typeDefinition.getQualifiedName(), "struct " + nameForTypeDefinition.calculateName(typeDefinition));
                }
            }
            ClientClassnameForMethod classnameFor = new ClientClassnameForMethod(conversions);
            model.put("classnameFor", (Object)classnameFor);
            model.put("cFileName", (Object)this.getSourceFileName());
            model.put("separateCommonCode", this.isSeparateCommonCode());
            model.put("findRootElement", (Object)new FindRootElementMethod());
            model.put("referencedNamespaces", (Object)new ReferencedNamespacesMethod());
            model.put("prefix", (Object)new PrefixMethod());
            model.put("xmlFunctionIdentifier", (Object)new XmlFunctionIdentifierMethod());
            model.put("accessorOverridesAnother", (Object)new AccessorOverridesAnotherMethod());
            this.debug("Generating the C data structures and (de)serialization functions...", new Object[0]);
            URL apiTemplate = this.getTemplateURL("api.fmt");
            this.processTemplate(apiTemplate, model);
        } else {
            this.info("Skipping C code generation because everything appears up-to-date.", new Object[0]);
        }
        ClientLibraryArtifact artifactBundle = new ClientLibraryArtifact(this.getName(), "c.client.library", "C Client Library");
        NamedFileArtifact sourceScript = new NamedFileArtifact(this.getName(), "c.client", new File(this.getGenerateDir(), this.getSourceFileName()));
        sourceScript.setArtifactType(ArtifactType.sources);
        sourceScript.setPublic(false);
        String description = this.readResource("library_description.fmt");
        artifactBundle.setDescription(description);
        artifactBundle.addArtifact((FileArtifact)sourceScript);
        if (this.isSeparateCommonCode()) {
            NamedFileArtifact commonSourceHeader = new NamedFileArtifact(this.getName(), "c.common.client", new File(this.getGenerateDir(), "enunciate-common.c"));
            commonSourceHeader.setPublic(false);
            commonSourceHeader.setArtifactType(ArtifactType.sources);
            commonSourceHeader.setDescription("Common code needed for all projects.");
            artifactBundle.addArtifact((FileArtifact)commonSourceHeader);
        }
        this.getEnunciate().addArtifact((Artifact)artifactBundle);
    }

    protected String readResource(String resource) throws IOException, EnunciateException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        ResourceMethod exampleResource = this.getModelInternal().findExampleResourceMethod();
        model.put("filename", this.getSourceFileName());
        String label = this.getLabel() == null ? (this.getEnunciate().getConfig() == null ? "enunciate" : this.getEnunciate().getConfig().getLabel()) : this.getLabel();
        NameForTypeDefinitionMethod nameForTypeDefinition = new NameForTypeDefinitionMethod(this.getTypeDefinitionNamePattern(), label, this.getModelInternal().getNamespacesToPrefixes());
        if (exampleResource != null) {
            TypeDefinition typeDefinition;
            ElementDeclaration el;
            if (exampleResource.getEntityParameter() != null && exampleResource.getEntityParameter().getXmlElement() != null) {
                el = exampleResource.getEntityParameter().getXmlElement();
                typeDefinition = null;
                if (el instanceof RootElementDeclaration) {
                    typeDefinition = this.getModelInternal().findTypeDefinition((ClassDeclaration)((RootElementDeclaration)el));
                } else if (el instanceof LocalElementDeclaration && ((LocalElementDeclaration)el).getElementTypeDeclaration() instanceof ClassDeclaration) {
                    typeDefinition = this.getModelInternal().findTypeDefinition((ClassDeclaration)((LocalElementDeclaration)el).getElementTypeDeclaration());
                }
                if (typeDefinition != null) {
                    model.put("input_element_name", nameForTypeDefinition.calculateName(typeDefinition));
                }
            }
            if (exampleResource.getRepresentationMetadata() != null && exampleResource.getRepresentationMetadata().getXmlElement() != null) {
                el = exampleResource.getRepresentationMetadata().getXmlElement();
                typeDefinition = null;
                if (el instanceof RootElementDeclaration) {
                    typeDefinition = this.getModelInternal().findTypeDefinition((ClassDeclaration)((RootElementDeclaration)el));
                } else if (el instanceof LocalElementDeclaration && ((LocalElementDeclaration)el).getElementTypeDeclaration() instanceof ClassDeclaration) {
                    typeDefinition = this.getModelInternal().findTypeDefinition((ClassDeclaration)((LocalElementDeclaration)el).getElementTypeDeclaration());
                }
                if (typeDefinition != null) {
                    model.put("output_element_name", nameForTypeDefinition.calculateName(typeDefinition));
                }
            }
        }
        URL res = CDeploymentModule.class.getResource(resource);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        try {
            this.processTemplate(res, model, out);
            out.flush();
            bytes.flush();
            return bytes.toString("utf-8");
        }
        catch (TemplateException e) {
            throw new EnunciateException((Throwable)e);
        }
    }

    protected String getSourceFileName() {
        String label = this.getLabel();
        if (label == null) {
            label = this.getEnunciate().getConfig() == null ? "enunciate" : this.getEnunciate().getConfig().getLabel();
        }
        return label + ".c";
    }

    protected ObjectWrapper getObjectWrapper() {
        return new DefaultObjectWrapper(){

            public TemplateModel wrap(Object obj) throws TemplateModelException {
                if (obj instanceof JavaDoc) {
                    return new FreemarkerJavaDoc((JavaDoc)obj);
                }
                return super.wrap(obj);
            }
        };
    }

    protected URL getTemplateURL(String template) {
        return CDeploymentModule.class.getResource(template);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTypeDefinitionNamePattern() {
        return this.typeDefinitionNamePattern;
    }

    public void setTypeDefinitionNamePattern(String typeDefinitionNamePattern) {
        this.typeDefinitionNamePattern = typeDefinitionNamePattern;
    }

    public String getEnumConstantNamePattern() {
        return this.enumConstantNamePattern;
    }

    public void setEnumConstantNamePattern(String enumConstantNamePattern) {
        this.enumConstantNamePattern = enumConstantNamePattern;
    }

    public boolean isForceEnable() {
        return this.forceEnable;
    }

    public void setForceEnable(boolean forceEnable) {
        this.forceEnable = forceEnable;
    }

    public boolean isSeparateCommonCode() {
        return this.separateCommonCode;
    }

    public void setSeparateCommonCode(boolean separateCommonCode) {
        this.separateCommonCode = separateCommonCode;
    }

    public RuleSet getConfigurationRules() {
        return new CRuleSet();
    }

    public Validator getValidator() {
        return new CValidator();
    }

    public Set<String> getFacetIncludes() {
        return this.facetIncludes;
    }

    public void addFacetInclude(String name) {
        if (name != null) {
            this.facetIncludes.add(name);
        }
    }

    public Set<String> getFacetExcludes() {
        return this.facetExcludes;
    }

    public void addFacetExclude(String name) {
        if (name != null) {
            this.facetExcludes.add(name);
        }
    }

    public boolean isDisabled() {
        if (this.isForceEnable()) {
            this.debug("C module is force-enabled via the 'require' attribute in the configuration.", new Object[0]);
            return false;
        }
        if (super.isDisabled()) {
            return true;
        }
        if (this.getModelInternal() != null && this.getModelInternal().getNamespacesToSchemas().isEmpty()) {
            this.debug("C module is disabled because there are no schema types.", new Object[0]);
            return true;
        }
        if (this.getModelInternal() != null && this.getModelInternal().getRootResources().isEmpty()) {
            this.debug("C module is disabled because there are no REST resources.", new Object[0]);
            return true;
        }
        return false;
    }
}

