/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.c;

import com.sun.mirror.declaration.Declaration;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.ComplexTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationResult;
import org.codehaus.enunciate.util.MapType;

public class CValidator
extends BaseValidator {
    public ValidationResult validateComplexType(ComplexTypeDefinition complexType) {
        ValidationResult result = super.validateComplexType(complexType);
        for (Attribute attribute : complexType.getAttributes()) {
            if (attribute.isXmlList()) {
                result.addWarning((Declaration)attribute, "The C client code won't serialize xml lists as an array, instead passing the list as a string that will need to be parsed. This may cause confusion to C consumers.");
            }
            if (!attribute.isCollectionType() || !attribute.isBinaryData()) continue;
            result.addError((Declaration)attribute, "The C client code doesn't support a collection of items that are binary data. You'll have to define separate accessors for each item or disable the C module.");
        }
        if (complexType.getValue() != null) {
            if (complexType.getValue().isXmlList()) {
                result.addWarning((Declaration)complexType.getValue(), "The C client code won't serialize xml lists as an array, instead passing the list as a string that will need to be parsed. This may cause confusion to C consumers.");
            }
            if (complexType.getValue().isCollectionType() && complexType.getValue().isBinaryData()) {
                result.addError((Declaration)complexType.getValue(), "The C client code doesn't support a collection of items that are binary data. You'll have to define separate accessors for each item or disable the C module.");
            }
        }
        for (Element element : complexType.getElements()) {
            if (element.isXmlList()) {
                result.addWarning((Declaration)element, "The C client code won't serialize xml lists as an array, instead passing the list as a string that will need to be parsed. This may cause confusion to C consumers.");
            }
            if (element.getAccessorType() instanceof MapType && !element.isAdapted()) {
                result.addError((Declaration)element, "The C client doesn't have a built-in way of serializing a Map. So you're going to have to use @XmlJavaTypeAdapter to supply your own adapter for the Map, or disable the C module.");
            }
            if (!element.isCollectionType()) continue;
            if (element.getChoices().size() > 1) {
                result.addWarning((Declaration)element, "The C client code doesn't fully support multiple choices for a collection. It has to separate each choice into its own array. This makes the C API a bit awkward to use and makes it impossible to preserve the order of the collection. If order is relevant, consider breaking out the choices into their own collection or otherwise refactoring the API.");
            }
            if (element.isBinaryData()) {
                result.addError((Declaration)element, "The C client code doesn't support a collection of items that are binary data. You'll have to define separate accessors for each item or disable the C module.");
            }
            for (Element choice : element.getChoices()) {
                if (!choice.isNillable()) continue;
                result.addWarning((Declaration)choice, "The C client code doesn't support nillable items in a collection (the nil items will be skipped). This may cause confusion to C consumers.");
            }
        }
        return result;
    }
}

