/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.c;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.WildcardType;
import freemarker.template.TemplateModelException;
import java.awt.Image;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import org.codehaus.enunciate.contract.jaxb.Accessor;

public class ClientClassnameForMethod
extends org.codehaus.enunciate.template.freemarker.ClientClassnameForMethod {
    private final Map<String, String> classConversions = new HashMap<String, String>();

    public ClientClassnameForMethod(Map<String, String> conversions) {
        super(conversions);
        this.setJdk15(false);
        this.classConversions.put(Boolean.class.getName(), "int");
        this.classConversions.put(String.class.getName(), "xmlChar");
        this.classConversions.put(Integer.class.getName(), "int");
        this.classConversions.put(Short.class.getName(), "short");
        this.classConversions.put(Byte.class.getName(), "unsigned char");
        this.classConversions.put(Double.class.getName(), "double");
        this.classConversions.put(Long.class.getName(), "long long");
        this.classConversions.put(BigInteger.class.getName(), "xmlChar");
        this.classConversions.put(BigDecimal.class.getName(), "xmlChar");
        this.classConversions.put(Float.class.getName(), "float");
        this.classConversions.put(Character.class.getName(), "unsigned short");
        this.classConversions.put(Date.class.getName(), "struct tm");
        this.classConversions.put(Timestamp.class.getName(), "struct tm");
        this.classConversions.put(DataHandler.class.getName(), "unsigned char");
        this.classConversions.put(Image.class.getName(), "unsigned char");
        this.classConversions.put(Source.class.getName(), "unsigned char");
        this.classConversions.put(QName.class.getName(), "struct QName");
        this.classConversions.put(URI.class.getName(), "xmlChar");
        this.classConversions.put(UUID.class.getName(), "xmlChar");
        this.classConversions.put(XMLGregorianCalendar.class.getName(), "struct tm");
        this.classConversions.put(GregorianCalendar.class.getName(), "struct tm");
        this.classConversions.put(Calendar.class.getName(), "struct tm");
        this.classConversions.put(Duration.class.getName(), "xmlChar");
        this.classConversions.put(JAXBElement.class.getName(), "struct xmlBasicNode");
        this.classConversions.put(Object.class.getName(), "struct xmlBasicNode");
        this.classConversions.putAll(conversions);
    }

    public String convert(TypeDeclaration declaration) throws TemplateModelException {
        String fqn = declaration.getQualifiedName();
        if (this.classConversions.containsKey(fqn)) {
            return this.classConversions.get(fqn);
        }
        if (this.isCollection(declaration)) {
            return "xmlNode";
        }
        return super.convert(declaration);
    }

    protected boolean isCollection(TypeDeclaration declaration) {
        DecoratedTypeMirror decorated;
        String fqn = declaration.getQualifiedName();
        if (Collection.class.getName().equals(fqn)) {
            return true;
        }
        if (Object.class.getName().equals(fqn)) {
            return false;
        }
        if (declaration instanceof ClassDeclaration && (decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)((ClassDeclaration)declaration).getSuperclass())).isCollection()) {
            return true;
        }
        for (InterfaceType interfaceType : declaration.getSuperinterfaces()) {
            DecoratedTypeMirror decorated2 = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)interfaceType);
            if (!decorated2.isCollection()) continue;
            return true;
        }
        return false;
    }

    public String convert(Accessor accessor) throws TemplateModelException {
        if (accessor.isXmlIDREF()) {
            return "xmlChar";
        }
        if (accessor.isXmlList()) {
            return "xmlChar";
        }
        return super.convert(accessor);
    }

    public String convert(TypeMirror typeMirror) throws TemplateModelException {
        DecoratedTypeMirror decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)typeMirror);
        if (decorated.isPrimitive()) {
            PrimitiveType.Kind kind = ((PrimitiveType)decorated).getKind();
            switch (kind) {
                case BOOLEAN: {
                    return "int";
                }
                case BYTE: {
                    return "unsigned char";
                }
                case INT: {
                    return "int";
                }
                case SHORT: {
                    return "short";
                }
                case FLOAT: {
                    return "float";
                }
                case DOUBLE: {
                    return "double";
                }
                case LONG: {
                    return "long long";
                }
                case CHAR: {
                    return "unsigned short";
                }
            }
            return "xmlChar";
        }
        if (decorated.isCollection()) {
            Collection typeArgs;
            if (decorated instanceof DeclaredType && (typeArgs = ((DeclaredType)typeMirror).getActualTypeArguments()).size() == 1) {
                WildcardType wildcardType;
                TypeMirror typeArg = (TypeMirror)typeArgs.iterator().next();
                if (typeArg instanceof WildcardType && (wildcardType = (WildcardType)typeArg).getUpperBounds() != null && !wildcardType.getUpperBounds().isEmpty()) {
                    typeArg = (TypeMirror)wildcardType.getUpperBounds().iterator().next();
                }
                return this.convert(typeArg);
            }
            return "xmlNode";
        }
        if (decorated.isArray()) {
            TypeMirror componentType = ((ArrayType)decorated).getComponentType();
            if (componentType instanceof PrimitiveType && ((PrimitiveType)componentType).getKind() == PrimitiveType.Kind.BYTE) {
                return "unsigned char";
            }
            return this.convert(componentType);
        }
        return super.convert(typeMirror);
    }
}

