/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.swagger;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.digester.RuleSet;
import org.codehaus.enunciate.apt.EnunciateFreemarkerModel;
import org.codehaus.enunciate.contract.Facet;
import org.codehaus.enunciate.contract.HasFacets;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethod;
import org.codehaus.enunciate.contract.jaxrs.RootResource;
import org.codehaus.enunciate.contract.validation.Validator;
import org.codehaus.enunciate.main.Artifact;
import org.codehaus.enunciate.main.Enunciate;
import org.codehaus.enunciate.main.FileArtifact;
import org.codehaus.enunciate.main.webapp.BaseWebAppFragment;
import org.codehaus.enunciate.main.webapp.WebAppComponent;
import org.codehaus.enunciate.main.webapp.WebAppFragment;
import org.codehaus.enunciate.modules.FacetAware;
import org.codehaus.enunciate.modules.FreemarkerDeploymentModule;
import org.codehaus.enunciate.modules.swagger.DatatypeNameForMethod;
import org.codehaus.enunciate.modules.swagger.SwaggerValidator;
import org.codehaus.enunciate.modules.swagger.config.SwaggerRuleSet;
import org.codehaus.enunciate.template.freemarker.UniqueContentTypesMethod;
import org.codehaus.enunciate.util.FacetFilter;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;

public class SwaggerDeploymentModule
extends FreemarkerDeploymentModule
implements FacetAware {
    private String dir = "ui";
    private String base;
    private String css;
    private String groupRestResources = "org.codehaus.enunciate.contract.jaxrs.Resource";
    private String defaultNamespace = null;
    private boolean applyBaseUriFilter = true;
    private String freemarkerProcessingTemplate;
    private URL freemarkerProcessingTemplateURL;
    private Set<String> facetIncludes = new TreeSet<String>();
    private Set<String> facetExcludes = new TreeSet<String>();

    public String getName() {
        return "swagger";
    }

    protected URL getTemplateURL() throws MalformedURLException {
        URL freemarkerProcessingTemplateURL = this.freemarkerProcessingTemplateURL;
        if (freemarkerProcessingTemplateURL == null) {
            freemarkerProcessingTemplateURL = this.freemarkerProcessingTemplate != null ? this.getEnunciate().resolvePath(this.freemarkerProcessingTemplate).toURI().toURL() : SwaggerDeploymentModule.class.getResource("swagger.fmt");
        }
        return freemarkerProcessingTemplateURL;
    }

    public void doFreemarkerGenerate() throws IOException, TemplateException {
        EnunciateFreemarkerModel model = this.getModel();
        File artifactDir = new File(this.getGenerateDir(), this.getDir());
        model.setFileOutputDirectory(artifactDir);
        boolean upToDate = this.isUpToDate(artifactDir);
        if (!upToDate) {
            TreeMap facetsToResourceMethods = new TreeMap();
            TreeMap<String, String> facetsToDocs = new TreeMap<String, String>();
            for (RootResource rootResource : this.getModelInternal().getRootResources()) {
                for (ResourceMethod resourceMethod : rootResource.getResourceMethods(true)) {
                    Set facets;
                    if (!FacetFilter.accept((HasFacets)resourceMethod) || (facets = resourceMethod.getFacets()) == null) continue;
                    for (Facet facet : facets) {
                        String fullpath;
                        ArrayList<ResourceMethod> methods;
                        String subcontext;
                        if (!facet.getName().equals(this.getGroupRestResources())) continue;
                        TreeMap<String, ArrayList<ResourceMethod>> group = (TreeMap<String, ArrayList<ResourceMethod>>)facetsToResourceMethods.get(facet.getValue());
                        if (group == null) {
                            group = new TreeMap<String, ArrayList<ResourceMethod>>();
                            facetsToResourceMethods.put(facet.getValue(), group);
                        }
                        if ((subcontext = (String)resourceMethod.getMetaData().get("defaultSubcontext")) == null) {
                            subcontext = "/rest";
                        }
                        if ((methods = (ArrayList<ResourceMethod>)group.get(fullpath = subcontext + resourceMethod.getFullpath())) == null) {
                            methods = new ArrayList<ResourceMethod>();
                            group.put(fullpath, methods);
                        }
                        methods.add(resourceMethod);
                        facetsToDocs.put(facet.getValue(), facet.getDocumentation());
                    }
                }
            }
            String defaultNamespace = this.getDefaultNamespace();
            if (defaultNamespace == null && model.getNamespacesToSchemas().size() == 1) {
                defaultNamespace = (String)model.getNamespacesToSchemas().keySet().iterator().next();
            }
            model.setVariable("uniqueContentTypes", (Object)new UniqueContentTypesMethod());
            model.put("datatypeNameFor", (Object)new DatatypeNameForMethod(model, defaultNamespace));
            model.put("facetsToResourceMethods", facetsToResourceMethods);
            model.put("facetsToDocs", facetsToDocs);
            model.put("swaggerDir", (Object)artifactDir.getName());
            this.buildBase(artifactDir);
            this.processTemplate(this.getTemplateURL(), model);
        } else {
            this.info("Skipping generation of Swagger since everything appears up-to-date...", new Object[0]);
        }
        HashSet<File> jsonFilesToValidate = new HashSet<File>();
        this.gatherJsonFiles(jsonFilesToValidate, artifactDir);
        ObjectMapper mapper = new ObjectMapper();
        for (File file : jsonFilesToValidate) {
            FileReader reader = new FileReader(file);
            try {
                mapper.readTree((Reader)reader);
            }
            catch (JsonProcessingException e) {
                this.warn("Error processing %s.", new Object[]{file.getAbsolutePath()});
                throw e;
            }
            finally {
                reader.close();
            }
        }
        BaseWebAppFragment webAppFragment = new BaseWebAppFragment(this.getName());
        webAppFragment.setBaseDir(this.getGenerateDir());
        ArrayList<WebAppComponent> filters = new ArrayList<WebAppComponent>();
        if (this.isApplyBaseUriFilter()) {
            WebAppComponent swaggerFilter = new WebAppComponent();
            swaggerFilter.setName("swagger-ui-filter");
            swaggerFilter.setClassname("org.codehaus.enunciate.webapp.IDLFilter");
            HashMap<String, String> initParams = new HashMap<String, String>();
            initParams.put("assumed-base-address", this.getModel().getBaseDeploymentAddress());
            initParams.put("match-prefix", "\"");
            initParams.put("content-type", "application/json");
            swaggerFilter.setInitParams(initParams);
            TreeSet<String> paths = new TreeSet<String>();
            for (File json : jsonFilesToValidate) {
                paths.add("/" + artifactDir.getName() + "/" + json.getName());
            }
            swaggerFilter.setUrlMappings(paths);
            filters.add(swaggerFilter);
        }
        webAppFragment.setFilters(filters);
        this.getEnunciate().addWebAppFragment((WebAppFragment)webAppFragment);
        this.getEnunciate().addArtifact((Artifact)new FileArtifact(this.getName(), "swagger", artifactDir));
    }

    private void gatherJsonFiles(Set<File> bucket, File buildDir) {
        File[] files;
        for (File file : files = buildDir.listFiles()) {
            if (file.getName().endsWith(".json")) {
                bucket.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.gatherJsonFiles(bucket, file);
        }
    }

    protected void buildBase(File buildDir) throws IOException {
        Enunciate enunciate = this.getEnunciate();
        buildDir.mkdirs();
        if (this.base == null) {
            InputStream discoveredBase = SwaggerDeploymentModule.class.getResourceAsStream("/META-INF/enunciate/swagger-base.zip");
            if (discoveredBase == null) {
                this.debug("Default base to be used for swagger base.", new Object[0]);
                enunciate.extractBase(this.loadDefaultBase(), buildDir);
                if (this.css != null) {
                    enunciate.copyFile(enunciate.resolvePath(this.css), new File(new File(buildDir, "css"), "screen.css"));
                }
            } else {
                this.debug("Discovered documentation base at /META-INF/enunciate/docs-base.zip", new Object[0]);
                enunciate.extractBase(discoveredBase, buildDir);
            }
        } else {
            File baseFile = enunciate.resolvePath(this.base);
            if (baseFile.isDirectory()) {
                this.debug("Directory %s to be used as the documentation base.", new Object[]{baseFile});
                enunciate.copyDir(baseFile, buildDir, new File[0]);
            } else {
                this.debug("Zip file %s to be extracted as the documentation base.", new Object[]{baseFile});
                enunciate.extractBase((InputStream)new FileInputStream(baseFile), buildDir);
            }
        }
    }

    protected InputStream loadDefaultBase() {
        return SwaggerDeploymentModule.class.getResourceAsStream("/swagger-ui.zip");
    }

    protected boolean isUpToDate(File artifactDir) {
        return this.enunciate.isUpToDateWithSources(artifactDir);
    }

    public RuleSet getConfigurationRules() {
        return new SwaggerRuleSet();
    }

    public Validator getValidator() {
        return new SwaggerValidator();
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public Set<String> getFacetIncludes() {
        return this.facetIncludes;
    }

    public void addFacetInclude(String name) {
        if (name != null) {
            this.facetIncludes.add(name);
        }
    }

    public Set<String> getFacetExcludes() {
        return this.facetExcludes;
    }

    public void addFacetExclude(String name) {
        if (name != null) {
            this.facetExcludes.add(name);
        }
    }

    public String getGroupRestResources() {
        return this.groupRestResources;
    }

    public void setGroupRestResources(String groupRestResources) {
        this.groupRestResources = groupRestResources;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public boolean isApplyBaseUriFilter() {
        return this.applyBaseUriFilter;
    }

    public void setApplyBaseUriFilter(boolean applyBaseUriFilter) {
        this.applyBaseUriFilter = applyBaseUriFilter;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public void setFreemarkerProcessingTemplate(String freemarkerProcessingTemplate) throws MalformedURLException {
        this.freemarkerProcessingTemplate = freemarkerProcessingTemplate;
    }

    public URL getFreemarkerProcessingTemplateURL() {
        return this.freemarkerProcessingTemplateURL;
    }

    public void setFreemarkerProcessingTemplateURL(URL freemarkerProcessingTemplateURL) {
        this.freemarkerProcessingTemplateURL = freemarkerProcessingTemplateURL;
    }
}

