/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.swagger;

import com.sun.mirror.declaration.Declaration;
import org.codehaus.enunciate.contract.jaxb.Attribute;
import org.codehaus.enunciate.contract.jaxb.ComplexTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.Element;
import org.codehaus.enunciate.contract.jaxb.SimpleTypeDefinition;
import org.codehaus.enunciate.contract.jaxb.TypeDefinition;
import org.codehaus.enunciate.contract.validation.BaseValidator;
import org.codehaus.enunciate.contract.validation.ValidationResult;

public class SwaggerValidator
extends BaseValidator {
    public ValidationResult validateSimpleType(SimpleTypeDefinition type) {
        ValidationResult result = super.validateSimpleType(type);
        this.validateTypeDefinition((TypeDefinition)type, result);
        return result;
    }

    public ValidationResult validateComplexType(ComplexTypeDefinition type) {
        ValidationResult result = super.validateComplexType(type);
        this.validateTypeDefinition((TypeDefinition)type, result);
        return result;
    }

    private void validateTypeDefinition(TypeDefinition type, ValidationResult result) {
        for (Attribute attribute : type.getAttributes()) {
            if (!attribute.getBaseType().isAnonymous()) continue;
            result.addError((Declaration)attribute, "Swagger isn't smart enough to handle anonymous types (such as maps).");
        }
        if (type.getValue() != null && type.getValue().getBaseType().isAnonymous()) {
            result.addError((Declaration)type.getValue(), "Swagger isn't smart enough to handle anonymous types (such as maps).");
        }
        for (Element element : type.getElements()) {
            if (element.isElementRefs() || element.getChoices().size() > 1) {
                result.addError((Declaration)element, "Swagger isn't smart enough to handle multiple choices for a property.");
            }
            for (Element choice : element.getChoices()) {
                if (choice.isElementRef() || !choice.getBaseType().isAnonymous()) continue;
                result.addError((Declaration)choice, "Swagger isn't smart enough to handle anonymous types (such as maps).");
            }
        }
    }
}

