/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.DiffListener;
import net.sf.clirr.core.Severity;
import org.codehaus.mojo.clirr.Difference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingListener
implements DiffListener {
    private final List<DiffListener> listeners;
    private final Severity minSeverity;
    private final List<Difference> ignored;
    private Map deferredMatchesPerDifference = new HashMap();

    public DelegatingListener(List<DiffListener> listeners, Severity minSeverity, List<Difference> ignored) {
        this.listeners = listeners == null ? Collections.emptyList() : listeners;
        this.minSeverity = minSeverity;
        this.ignored = ignored == null ? Collections.emptyList() : ignored;
    }

    public void start() {
        this.deferredMatchesPerDifference.clear();
        for (DiffListener listener : this.listeners) {
            listener.start();
        }
    }

    public void reportDiff(ApiDifference apiDifference) {
        if (!(this.minSeverity != null && this.minSeverity.compareTo((Object)apiDifference.getMaximumSeverity()) > 0 || this.isIgnored(apiDifference))) {
            for (DiffListener listener : this.listeners) {
                listener.reportDiff(apiDifference);
            }
        }
    }

    public void stop() {
        for (Map.Entry perDifferenceEntry : this.deferredMatchesPerDifference.entrySet()) {
            Difference diff = (Difference)perDifferenceEntry.getKey();
            Map diffsPerId = (Map)perDifferenceEntry.getValue();
            for (List apiDiffs : diffsPerId.values()) {
                if (diff.resolveDefferedMatches(apiDiffs)) continue;
                for (DiffListener listener : this.listeners) {
                    Iterator j = apiDiffs.iterator();
                    while (j.hasNext()) {
                        listener.reportDiff((ApiDifference)j.next());
                    }
                }
            }
        }
        for (DiffListener listener : this.listeners) {
            listener.stop();
        }
    }

    private boolean isIgnored(ApiDifference apiDiff) {
        if (this.ignored == null) {
            return false;
        }
        boolean someDeferred = false;
        boolean matched = false;
        for (Difference difference : this.ignored) {
            if (difference == null) continue;
            Difference.Result res = difference.matches(apiDiff);
            switch (res.getCode()) {
                case 0: {
                    matched = true;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ArrayList<ApiDifference> diffs;
                    HashMap<Object, ArrayList<ApiDifference>> diffsPerDifferentiator = (HashMap<Object, ArrayList<ApiDifference>>)this.deferredMatchesPerDifference.get(this.ignored);
                    if (diffsPerDifferentiator == null) {
                        diffsPerDifferentiator = new HashMap<Object, ArrayList<ApiDifference>>();
                        this.deferredMatchesPerDifference.put(this.ignored, diffsPerDifferentiator);
                    }
                    if ((diffs = (ArrayList<ApiDifference>)diffsPerDifferentiator.get(res.getDifferentiator())) == null) {
                        diffs = new ArrayList<ApiDifference>();
                        diffsPerDifferentiator.put(res.getDifferentiator(), diffs);
                    }
                    diffs.add(apiDiff);
                    someDeferred = true;
                }
            }
        }
        return matched || someDeferred;
    }
}

