/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:clirr-maven-plugin:2.5", 0);
        this.append(sb, "", 0);
        this.append(sb, "Clirr Maven Plugin", 0);
        this.append(sb, "Clirr is a tool that checks Java libraries for binary and source compatibility with older releases. Basically you give it two sets of jar files and Clirr dumps out a list of changes in the public API. The clirr-maven-plugin can be configured to break the build, if it detects incompatible api changes. In a continuous integration process, the clirr-maven-plugin can automatically prevent accidental introduction of binary or source compatibility problems. Additionally, the plugin can generate a report as part of the generated site.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "check".equals(this.goal)) {
            this.append(sb, "clirr:check", 0);
            this.append(sb, "Check for compatibility with previous version.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The classes of this project to compare the last release against.", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonArtifacts", 2);
                this.append(sb, "List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId and a version number. Optionally it may have a classifier (default null) and a type (default 'jar').", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonVersion (Default: (,${project.version}))", 2);
                this.append(sb, "Version to compare the current code against.", 3);
                this.append(sb, "Expression: ${comparisonVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Whether to fail on errors.", 3);
                this.append(sb, "Expression: ${failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnInfo (Default: false)", 2);
                this.append(sb, "Whether to fail on info.", 3);
                this.append(sb, "Expression: ${failOnInfo}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnWarning (Default: false)", 2);
                this.append(sb, "Whether to fail on warnings.", 3);
                this.append(sb, "Expression: ${failOnWarning}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignored", 2);
                this.append(sb, "A list of differences reported by Clirr that should be ignored when producing the final report. Values specified here will be joined with the ones specified using the 'ignoredDifferencesFile' parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoredDifferencesFile", 2);
                this.append(sb, "A path to the XML file containing the ignored differences definitions. Values specified int the file will be joined with the ones specified using the 'ignored' parameter.\nFile Format\n<differences>\n\u00a0\u00a0...\n\u00a0\u00a0<difference>\n\u00a0\u00a0\u00a0\u00a0<className>com.thoughtworks.qdox.parser.impl.Parser</className>\n\u00a0\u00a0\u00a0\u00a0<field>*</field>\n\u00a0\u00a0</difference>\n\u00a0\u00a0...\n</differences>\n", 3);
                this.append(sb, "Expression: ${clirr.ignoredDifferencesFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logResults (Default: false)", 2);
                this.append(sb, "Whether to log the results to the console or not.", 3);
                this.append(sb, "Expression: ${logResults}", 3);
                this.append(sb, "", 0);
                this.append(sb, "minSeverity (Default: warning)", 2);
                this.append(sb, "Show only messages of this severity or higher. Valid values are info, warning and error.", 3);
                this.append(sb, "Expression: ${minSeverity}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Flag to easily skip execution.", 3);
                this.append(sb, "Expression: ${clirr.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "textOutputFile", 2);
                this.append(sb, "A text output file to render to. If omitted, no output is rendered to a text file.", 3);
                this.append(sb, "Expression: ${textOutputFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutputFile", 2);
                this.append(sb, "An XML file to render to. If omitted, no output is rendered to an XML file.", 3);
                this.append(sb, "Expression: ${xmlOutputFile}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "check-arbitrary".equals(this.goal)) {
            this.append(sb, "clirr:check-arbitrary", 0);
            this.append(sb, "Check for compatibility between two arbitrary artifact sets.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The classes of this project to compare the last release against.", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonArtifacts", 2);
                this.append(sb, "List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId and a version number. Optionally it may have a classifier (default null) and a type (default 'jar').", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonVersion (Default: (,${project.version}))", 2);
                this.append(sb, "Version to compare the current code against.", 3);
                this.append(sb, "Expression: ${comparisonVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Whether to fail on errors.", 3);
                this.append(sb, "Expression: ${failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnWarning (Default: false)", 2);
                this.append(sb, "Whether to fail on warnings.", 3);
                this.append(sb, "Expression: ${failOnWarning}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignored", 2);
                this.append(sb, "A list of differences reported by Clirr that should be ignored when producing the final report. Values specified here will be joined with the ones specified using the 'ignoredDifferencesFile' parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoredDifferencesFile", 2);
                this.append(sb, "A path to the XML file containing the ignored differences definitions. Values specified int the file will be joined with the ones specified using the 'ignored' parameter.\nFile Format\n<differences>\n\u00a0\u00a0...\n\u00a0\u00a0<difference>\n\u00a0\u00a0\u00a0\u00a0<className>com.thoughtworks.qdox.parser.impl.Parser</className>\n\u00a0\u00a0\u00a0\u00a0<field>*</field>\n\u00a0\u00a0</difference>\n\u00a0\u00a0...\n</differences>\n", 3);
                this.append(sb, "Expression: ${clirr.ignoredDifferencesFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logResults (Default: false)", 2);
                this.append(sb, "Whether to log the results to the console or not.", 3);
                this.append(sb, "Expression: ${logResults}", 3);
                this.append(sb, "", 0);
                this.append(sb, "minSeverity (Default: warning)", 2);
                this.append(sb, "Show only messages of this severity or higher. Valid values are info, warning and error.", 3);
                this.append(sb, "Expression: ${minSeverity}", 3);
                this.append(sb, "", 0);
                this.append(sb, "newComparisonArtifacts", 2);
                this.append(sb, "List of artifacts to compare to baseline.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "oldComparisonArtifacts", 2);
                this.append(sb, "List of artifacts to serve as a baseline to compare against.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Flag to easily skip execution.", 3);
                this.append(sb, "Expression: ${clirr.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "textOutputFile", 2);
                this.append(sb, "A text output file to render to. If omitted, no output is rendered to a text file.", 3);
                this.append(sb, "Expression: ${textOutputFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutputFile", 2);
                this.append(sb, "An XML file to render to. If omitted, no output is rendered to an XML file.", 3);
                this.append(sb, "Expression: ${xmlOutputFile}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "check-no-fork".equals(this.goal)) {
            this.append(sb, "clirr:check-no-fork", 0);
            this.append(sb, "Check for compatibility with previous version without forking the project", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The classes of this project to compare the last release against.", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonArtifacts", 2);
                this.append(sb, "List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId and a version number. Optionally it may have a classifier (default null) and a type (default 'jar').", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonVersion (Default: (,${project.version}))", 2);
                this.append(sb, "Version to compare the current code against.", 3);
                this.append(sb, "Expression: ${comparisonVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Whether to fail on errors.", 3);
                this.append(sb, "Expression: ${failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnInfo (Default: false)", 2);
                this.append(sb, "Whether to fail on info.", 3);
                this.append(sb, "Expression: ${failOnInfo}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnWarning (Default: false)", 2);
                this.append(sb, "Whether to fail on warnings.", 3);
                this.append(sb, "Expression: ${failOnWarning}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignored", 2);
                this.append(sb, "A list of differences reported by Clirr that should be ignored when producing the final report. Values specified here will be joined with the ones specified using the 'ignoredDifferencesFile' parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoredDifferencesFile", 2);
                this.append(sb, "A path to the XML file containing the ignored differences definitions. Values specified int the file will be joined with the ones specified using the 'ignored' parameter.\nFile Format\n<differences>\n\u00a0\u00a0...\n\u00a0\u00a0<difference>\n\u00a0\u00a0\u00a0\u00a0<className>com.thoughtworks.qdox.parser.impl.Parser</className>\n\u00a0\u00a0\u00a0\u00a0<field>*</field>\n\u00a0\u00a0</difference>\n\u00a0\u00a0...\n</differences>\n", 3);
                this.append(sb, "Expression: ${clirr.ignoredDifferencesFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logResults (Default: false)", 2);
                this.append(sb, "Whether to log the results to the console or not.", 3);
                this.append(sb, "Expression: ${logResults}", 3);
                this.append(sb, "", 0);
                this.append(sb, "minSeverity (Default: warning)", 2);
                this.append(sb, "Show only messages of this severity or higher. Valid values are info, warning and error.", 3);
                this.append(sb, "Expression: ${minSeverity}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Flag to easily skip execution.", 3);
                this.append(sb, "Expression: ${clirr.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "textOutputFile", 2);
                this.append(sb, "A text output file to render to. If omitted, no output is rendered to a text file.", 3);
                this.append(sb, "Expression: ${textOutputFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutputFile", 2);
                this.append(sb, "An XML file to render to. If omitted, no output is rendered to an XML file.", 3);
                this.append(sb, "Expression: ${xmlOutputFile}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "clirr".equals(this.goal)) {
            this.append(sb, "clirr:clirr", 0);
            this.append(sb, "Generate a report from the Clirr output.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The classes of this project to compare the last release against.", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonArtifacts", 2);
                this.append(sb, "List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId and a version number. Optionally it may have a classifier (default null) and a type (default 'jar').", 3);
                this.append(sb, "", 0);
                this.append(sb, "comparisonVersion (Default: (,${project.version}))", 2);
                this.append(sb, "Version to compare the current code against.", 3);
                this.append(sb, "Expression: ${comparisonVersion}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3);
                this.append(sb, "", 0);
                this.append(sb, "htmlReport (Default: true)", 2);
                this.append(sb, "Whether to render the HTML report or not.", 3);
                this.append(sb, "Expression: ${htmlReport}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignored", 2);
                this.append(sb, "A list of differences reported by Clirr that should be ignored when producing the final report. Values specified here will be joined with the ones specified using the 'ignoredDifferencesFile' parameter.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoredDifferencesFile", 2);
                this.append(sb, "A path to the XML file containing the ignored differences definitions. Values specified int the file will be joined with the ones specified using the 'ignored' parameter.\nFile Format\n<differences>\n\u00a0\u00a0...\n\u00a0\u00a0<difference>\n\u00a0\u00a0\u00a0\u00a0<className>com.thoughtworks.qdox.parser.impl.Parser</className>\n\u00a0\u00a0\u00a0\u00a0<field>*</field>\n\u00a0\u00a0</difference>\n\u00a0\u00a0...\n</differences>\n", 3);
                this.append(sb, "Expression: ${clirr.ignoredDifferencesFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3);
                this.append(sb, "", 0);
                this.append(sb, "linkXRef (Default: true)", 2);
                this.append(sb, "Link the violation line numbers to the source Xref. This will create links if the JXR Plugin is being used.", 3);
                this.append(sb, "Expression: ${linkXRef}", 3);
                this.append(sb, "", 0);
                this.append(sb, "logResults (Default: false)", 2);
                this.append(sb, "Whether to log the results to the console or not.", 3);
                this.append(sb, "Expression: ${logResults}", 3);
                this.append(sb, "", 0);
                this.append(sb, "minSeverity (Default: warning)", 2);
                this.append(sb, "Show only messages of this severity or higher. Valid values are info, warning and error.", 3);
                this.append(sb, "Expression: ${minSeverity}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Specifies the directory where the report will be generated.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "showSummary (Default: true)", 2);
                this.append(sb, "Whether to show the summary of the number of errors, warnings and informational messages.", 3);
                this.append(sb, "Expression: ${showSummary}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Flag to easily skip execution.", 3);
                this.append(sb, "Expression: ${clirr.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "textOutputFile", 2);
                this.append(sb, "A text output file to render to. If omitted, no output is rendered to a text file.", 3);
                this.append(sb, "Expression: ${textOutputFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutputFile", 2);
                this.append(sb, "An XML file to render to. If omitted, no output is rendered to an XML file.", 3);
                this.append(sb, "Expression: ${xmlOutputFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "xrefLocation (Default: ${project.build.directory}/site/xref)", 2);
                this.append(sb, "Location of the Xrefs to link to.", 3);
                this.append(sb, "Expression: ${xrefLocation}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "clirr:help", 0);
            this.append(sb, "Display help information on clirr-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0clirr:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

