/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.mojo.nbm.AbstractNbmMojo;
import org.codehaus.mojo.nbm.CreateClusterAppMojo;
import org.codehaus.mojo.nbm.NetBeansManifestUpdateMojo;
import org.codehaus.mojo.nbm.model.NbmResource;
import org.codehaus.mojo.nbm.model.NetBeansModule;
import org.codehaus.mojo.nbm.utils.ExamineManifest;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.nbbuild.CreateModuleXML;
import org.netbeans.nbbuild.JHIndexer;
import org.netbeans.nbbuild.MakeListOfNBM;

public abstract class CreateNetBeansFileStructure
extends AbstractNbmMojo {
    @Parameter(defaultValue="${project.build.directory}/nbm", property="maven.nbm.buildDir")
    protected File nbmBuildDir;
    @Parameter(required=true, readonly=true, property="project.build.directory")
    protected File buildDir;
    @Parameter(alias="jarname", property="project.build.finalName")
    protected String finalName;
    @Parameter(defaultValue="${basedir}/src/main/nbm/module.xml")
    protected File descriptor;
    @Parameter(required=true, defaultValue="extra")
    protected String cluster;
    @Deprecated
    @Parameter(defaultValue="${basedir}/src/main/javahelp")
    protected File nbmJavahelpSource;
    @Parameter(required=true, readonly=true, property="project")
    protected MavenProject project;
    @Parameter
    protected Resource[] nbmResources;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(defaultValue="normal")
    protected String moduleType;
    @Parameter(defaultValue="${project.groupId}.${project.artifactId}")
    private String codeNameBase;
    @Parameter
    private List<String> externals;
    @Component
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession session;
    protected Project antProject;
    protected NetBeansModule module;
    protected File clusterDir;
    protected String moduleJarName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.antProject = this.registerNbmAntTasks();
        this.module = this.descriptor != null && this.descriptor.exists() ? this.readModuleDescriptor(this.descriptor) : this.createDefaultDescriptor(this.project, false);
        String type = this.moduleType;
        if ("normal".equals(type) && this.module.getModuleType() != null) {
            type = this.module.getModuleType();
            this.getLog().warn((CharSequence)"moduleType in module descriptor is deprecated, use the plugin's parameter moduleType");
        }
        if (!("normal".equals(type) || "autoload".equals(type) || "eager".equals(type) || "disabled".equals(type))) {
            this.getLog().error((CharSequence)"Only 'normal,autoload,eager,disabled' are allowed values in the moduleType parameter");
        }
        boolean autoload = "autoload".equals(type);
        boolean eager = "eager".equals(type);
        boolean disabled = "disabled".equals(type);
        String moduleName = this.codeNameBase;
        if (this.module.getCodeNameBase() != null) {
            moduleName = this.module.getCodeNameBase();
            this.getLog().warn((CharSequence)"codeNameBase in module descriptor is deprecated, use the plugin's parameter codeNameBase");
        }
        moduleName = NetBeansManifestUpdateMojo.stripVersionFromCodebaseName(moduleName.replaceAll("-", "."));
        this.moduleJarName = moduleName.replace('.', '-');
        if ("extra".equals(this.cluster) && this.module.getCluster() != null) {
            this.getLog().warn((CharSequence)"Parameter cluster in module descriptor is deprecated, use the plugin configuration element.");
            this.cluster = this.module.getCluster();
        }
        File jarFile = new File(this.buildDir, this.finalName + ".jar");
        this.clusterDir = new File(this.nbmBuildDir, "netbeans" + File.separator + this.cluster);
        File moduleJarLocation = new File(this.clusterDir, "modules");
        moduleJarLocation.mkdirs();
        File moduleFile = new File(moduleJarLocation, this.moduleJarName + ".jar");
        try {
            boolean needPlainCopy;
            block37: {
                needPlainCopy = false;
                try (FileInputStream is = new FileInputStream(jarFile);){
                    JarInputStream jis = new JarInputStream(is);
                    Manifest m = jis.getManifest();
                    Attributes a = m.getMainAttributes();
                    String classPath = (String)a.remove(new Attributes.Name("X-Class-Path"));
                    if (classPath == null) {
                        needPlainCopy = true;
                        break block37;
                    }
                    this.getLog().info((CharSequence)("Copying module JAR to " + moduleJarLocation + " with manifest updates"));
                    a.putValue("Class-Path", classPath);
                    a.remove(new Attributes.Name("Maven-Class-Path"));
                    try (FileOutputStream os = new FileOutputStream(moduleFile);){
                        JarEntry entry;
                        JarOutputStream jos = new JarOutputStream((OutputStream)os, m);
                        while ((entry = jis.getNextJarEntry()) != null) {
                            int c;
                            JarEntry entry2 = new JarEntry(entry);
                            jos.putNextEntry(entry2);
                            while ((c = jis.read()) != -1) {
                                jos.write(c);
                            }
                            jos.closeEntry();
                        }
                        jos.finish();
                        jos.close();
                    }
                }
            }
            if (needPlainCopy) {
                this.getLog().info((CharSequence)("Copying module JAR to " + moduleJarLocation));
                FileUtils.getFileUtils().copyFile(jarFile, moduleFile, null, true, false);
            }
        }
        catch (IOException x) {
            throw new MojoExecutionException("Cannot copy module jar", (Exception)x);
        }
        ExamineManifest modExaminator = new ExamineManifest(this.getLog());
        modExaminator.setJarFile(moduleFile);
        modExaminator.checkFile();
        String classpathValue = modExaminator.getClasspath();
        if (this.module != null) {
            List artifacts = this.project.getRuntimeArtifacts();
            for (Artifact artifact : artifacts) {
                File source = artifact.getFile();
                String path = NetBeansManifestUpdateMojo.artifactToClassPathEntry(artifact, this.codeNameBase);
                if (!classpathValue.contains(path)) continue;
                File target = new File(moduleJarLocation, path);
                File targetDir = target.getParentFile();
                targetDir.mkdirs();
                try {
                    FileUtils.getFileUtils().copyFile(source, target, null, true, false);
                    if (this.externals == null || !this.externals.contains(artifact.getGroupId() + ":" + artifact.getArtifactId())) continue;
                    String name = target.getName();
                    this.getLog().info((CharSequence)("Using *.external replacement for " + name));
                    try (PrintWriter external = new PrintWriter(new File(targetDir, name + ".external"), "UTF-8");){
                        CreateNetBeansFileStructure.writeExternal(external, artifact);
                    }
                }
                catch (IOException ex) {
                    this.getLog().error((CharSequence)"Cannot copy library jar");
                    throw new MojoExecutionException("Cannot copy library jar", (Exception)ex);
                }
            }
            if (this.nbmResources != null) {
                this.copyNbmResources();
            }
            this.copyDeprecatedNbmResources();
        }
        if (this.nbmJavahelpSource.exists()) {
            this.getLog().warn((CharSequence)"src/main/javahelp/ deprecated; use @HelpSetRegistration instead");
            File javahelp_target = new File(this.buildDir, "javahelp");
            String javahelpbase = this.moduleJarName.replace('-', File.separatorChar) + File.separator + "docs";
            String javahelpSearch = "JavaHelpSearch";
            File b = new File(javahelp_target, javahelpbase);
            File p = new File(b, javahelpSearch);
            p.mkdirs();
            Copy cp = (Copy)this.antProject.createTask("copy");
            cp.setTodir(javahelp_target);
            FileSet set = new FileSet();
            set.setDir(this.nbmJavahelpSource);
            cp.addFileset(set);
            cp.execute();
            this.getLog().info((CharSequence)"Generating JavaHelp Index...");
            JHIndexer jhTask = (JHIndexer)this.antProject.createTask("jhindexer");
            jhTask.setBasedir(b);
            jhTask.setDb(p);
            jhTask.setIncludes("**/*.html");
            jhTask.setExcludes(javahelpSearch);
            Path path = new Path(this.antProject);
            jhTask.setClassPath(path);
            this.clearStaticFieldsInJavaHelpIndexer();
            try {
                jhTask.execute();
            }
            catch (BuildException e) {
                this.getLog().error((CharSequence)"Cannot generate JavaHelp index.");
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            File helpJarLocation = new File(this.clusterDir, "modules/docs");
            helpJarLocation.mkdirs();
            Jar jar = (Jar)this.antProject.createTask("jar");
            jar.setDestFile(new File(helpJarLocation, this.moduleJarName + ".jar"));
            set = new FileSet();
            set.setDir(javahelp_target);
            jar.addFileset(set);
            jar.execute();
        }
        File configDir = new File(this.clusterDir, "config" + File.separator + "Modules");
        configDir.mkdirs();
        CreateModuleXML moduleXmlTask = (CreateModuleXML)this.antProject.createTask("createmodulexml");
        moduleXmlTask.setXmldir(configDir);
        FileSet fs = new FileSet();
        fs.setDir(this.clusterDir);
        fs.setIncludes("modules" + File.separator + this.moduleJarName + ".jar");
        if (autoload) {
            moduleXmlTask.addAutoload(fs);
        } else if (eager) {
            moduleXmlTask.addEager(fs);
        } else if (disabled) {
            moduleXmlTask.addDisabled(fs);
        } else {
            moduleXmlTask.addEnabled(fs);
        }
        try {
            moduleXmlTask.execute();
        }
        catch (BuildException e) {
            this.getLog().error((CharSequence)"Cannot generate config file.");
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        MakeListOfNBM makeTask = (MakeListOfNBM)this.antProject.createTask("genlist");
        this.antProject.setNewProperty("module.name", this.finalName);
        this.antProject.setProperty("cluster.dir", this.cluster);
        FileSet set = makeTask.createFileSet();
        set.setDir(this.clusterDir);
        PatternSet pattern = set.createPatternSet();
        pattern.setIncludes("**");
        makeTask.setModule("modules" + File.separator + this.moduleJarName + ".jar");
        makeTask.setOutputfiledir(this.clusterDir);
        try {
            makeTask.execute();
        }
        catch (BuildException e) {
            this.getLog().error((CharSequence)"Cannot Generate nbm list");
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void copyDeprecatedNbmResources() throws BuildException, MojoExecutionException {
        List<NbmResource> ress = this.module.getNbmResources();
        if (ress.size() > 0) {
            this.getLog().warn((CharSequence)"NBM resources defined in module descriptor are deprecated. Please configure NBM resources in plugin configuration.");
            Copy cp = (Copy)this.antProject.createTask("copy");
            cp.setTodir(this.clusterDir);
            HashMap<File, ArrayList<FileSet>> customPaths = new HashMap<File, ArrayList<FileSet>>();
            boolean hasStandard = false;
            for (NbmResource nbmResource : ress) {
                if (nbmResource.getBaseDirectory() == null) continue;
                File base = new File(this.project.getBasedir(), nbmResource.getBaseDirectory());
                FileSet set = new FileSet();
                set.setDir(base);
                for (String inc : nbmResource.getIncludes()) {
                    set.createInclude().setName(inc);
                }
                for (String exc : nbmResource.getExcludes()) {
                    set.createExclude().setName(exc);
                }
                if (nbmResource.getRelativeClusterPath() != null) {
                    File path = new File(this.clusterDir, nbmResource.getRelativeClusterPath());
                    ArrayList<FileSet> col = (ArrayList<FileSet>)customPaths.get(path);
                    if (col == null) {
                        col = new ArrayList<FileSet>();
                        customPaths.put(path, col);
                    }
                    col.add(set);
                    continue;
                }
                cp.addFileset(set);
                hasStandard = true;
            }
            try {
                if (hasStandard) {
                    cp.execute();
                }
                if (customPaths.size() > 0) {
                    for (Map.Entry entry : customPaths.entrySet()) {
                        cp = (Copy)this.antProject.createTask("copy");
                        cp.setTodir((File)entry.getKey());
                        for (FileSet set : (Collection)entry.getValue()) {
                            cp.addFileset(set);
                        }
                        cp.execute();
                    }
                }
            }
            catch (BuildException e) {
                this.getLog().error((CharSequence)"Cannot copy additional resources into the nbm file");
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private void clearStaticFieldsInJavaHelpIndexer() {
        try {
            Class<?> clazz = Class.forName("com.sun.java.help.search.Indexer");
            Field fld = clazz.getDeclaredField("kitRegistry");
            fld.setAccessible(true);
            Hashtable hash = (Hashtable)fld.get(null);
            hash.clear();
            clazz = Class.forName("com.sun.java.help.search.HTMLIndexerKit");
            fld = clazz.getDeclaredField("defaultParser");
            fld.setAccessible(true);
            fld.set(null, null);
            fld = clazz.getDeclaredField("defaultCallback");
            fld.setAccessible(true);
            fld.set(null, null);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(CreateNetBeansFileStructure.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CreateNetBeansFileStructure.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(CreateNetBeansFileStructure.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(CreateNetBeansFileStructure.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CreateNetBeansFileStructure.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void copyNbmResources() throws MojoExecutionException {
        try {
            if (StringUtils.isEmpty((String)this.encoding) && this.isFilteringEnabled(this.nbmResources)) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(Arrays.asList(this.nbmResources), this.clusterDir, this.project, this.encoding, Collections.EMPTY_LIST, Collections.EMPTY_LIST, this.session);
            mavenResourcesExecution.setEscapeWindowsPaths(true);
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private boolean isFilteringEnabled(Resource[] resources) {
        for (Resource resource : resources) {
            if (!resource.isFiltering()) continue;
            return true;
        }
        return false;
    }

    static void writeExternal(PrintWriter w, Artifact artifact) throws IOException {
        w.write("CRC:");
        File file = artifact.getFile();
        w.write(Long.toString(CreateClusterAppMojo.crcForFile(file).getValue()));
        w.write("\nSIZE:");
        w.write(Long.toString(file.length()));
        w.write("\nURL:m2:/");
        w.write(artifact.getGroupId());
        w.write(58);
        w.write(artifact.getArtifactId());
        w.write(58);
        w.write(artifact.getVersion());
        w.write(58);
        w.write(artifact.getType());
        if (artifact.getClassifier() != null) {
            w.write(58);
            w.write(artifact.getClassifier());
        }
        w.write("\nURL:");
        w.write("http://repo.maven.apache.org/maven2/");
        w.write(new DefaultRepositoryLayout().pathOf(artifact));
        w.write(10);
        w.flush();
    }
}

