/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.redback.components.springutils;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class CachingByTypeBeanFactory
extends DefaultListableBeanFactory {
    private Logger log = LoggerFactory.getLogger(CachingByTypeBeanFactory.class);
    ConcurrentHashMap<TypeKey, String[]> cachedBeanNamesForType = new ConcurrentHashMap();

    public String[] getBeanNamesForType(Class type) {
        return this.getBeanNamesForType(type, true, true);
    }

    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        TypeKey typeKey = new TypeKey(type, includeNonSingletons, allowEagerInit);
        if (this.cachedBeanNamesForType.containsKey(typeKey)) {
            this.log.debug("will retrieve from cache: {}", (Object)typeKey);
            return this.cachedBeanNamesForType.get(typeKey);
        }
        String[] value = super.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        if (this.log.isDebugEnabled()) {
            this.log.debug("will add to cache: {} : {}", (Object)typeKey, Arrays.asList(value));
        }
        this.cachedBeanNamesForType.putIfAbsent(typeKey, value);
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeKey {
        Class<?> type;
        boolean includeNonSingletons;
        boolean allowEagerInit;

        TypeKey(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
            this.type = type;
            this.includeNonSingletons = includeNonSingletons;
            this.allowEagerInit = allowEagerInit;
        }

        public String toString() {
            return "TypeKey{" + this.type + " " + this.includeNonSingletons + " " + this.allowEagerInit + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeKey typeKey = (TypeKey)o;
            if (this.allowEagerInit != typeKey.allowEagerInit) {
                return false;
            }
            if (this.includeNonSingletons != typeKey.includeNonSingletons) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(typeKey.type) : typeKey.type != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.includeNonSingletons ? 1 : 0);
            result = 31 * result + (this.allowEagerInit ? 1 : 0);
            return result;
        }
    }
}

