/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.graph.DirectedGraph;
import org.sonar.graph.Dsm;
import org.sonar.graph.DsmManualSorter;
import org.sonar.graph.Edge;
import org.sonar.graph.StringEdge;

public final class DsmScanner {
    private final LineNumberReader reader;
    private static final String CELL_SEPARATOR = "|";
    private static final char FEEDBACK_EDGE_FLAG = '*';
    private final DirectedGraph<String, StringEdge> graph = DirectedGraph.createStringDirectedGraph();
    private String[] vertices;
    private Set<Edge> feedbackEdges = new LinkedHashSet<Edge>();

    private DsmScanner(Reader reader) {
        this.reader = new LineNumberReader(reader);
    }

    private Dsm<String> scan() {
        try {
            this.readColumnHeadersAndcreateDsmBuilder();
            for (int i = 0; i < this.vertices.length; ++i) {
                this.readRow(i);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read DSM content.", e);
        }
        Dsm<String> dsm = new Dsm<String>(this.graph, this.graph.getVertices(), this.feedbackEdges);
        DsmManualSorter.sort(dsm, Arrays.asList(this.vertices));
        return dsm;
    }

    private void readRow(int i) throws IOException {
        String[] tokens = this.splitLine(this.reader.readLine());
        for (int j = 1; j < tokens.length - 1; ++j) {
            int toVertexIndex = j - 1;
            int weight = this.extractWeight(tokens[j]);
            if (i == toVertexIndex) continue;
            StringEdge edge = new StringEdge(this.vertices[toVertexIndex], this.vertices[i], weight);
            if (this.isFeedbackEdge(tokens[j])) {
                this.feedbackEdges.add(edge);
            }
            this.graph.addEdge(edge);
        }
    }

    private boolean isFeedbackEdge(String cellContent) {
        return cellContent.indexOf(42) != -1;
    }

    private int extractWeight(String stringContent) {
        try {
            return Integer.valueOf(stringContent.replace('*', ' ').trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void readColumnHeadersAndcreateDsmBuilder() throws IOException {
        String[] tokens = this.splitLine(this.reader.readLine());
        if (tokens != null) {
            this.vertices = new String[tokens.length - 2];
            System.arraycopy(tokens, 1, this.vertices, 0, tokens.length - 2);
            this.graph.addVertices(Arrays.asList(this.vertices));
        }
    }

    private String[] splitLine(String line) {
        if (line == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] tokens = line.split("\\|");
        String[] result = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            result[i] = tokens[i].trim();
        }
        return result;
    }

    public static Dsm<String> scan(String textDsm) {
        StringReader reader = new StringReader(textDsm);
        return DsmScanner.scan(reader);
    }

    public static Dsm<String> scan(Reader dsmReader) {
        DsmScanner scanner = new DsmScanner(dsmReader);
        return scanner.scan();
    }
}

