/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans.nt;

import jcifs.Configuration;
import jcifs.internal.smb1.trans.nt.SmbComNtTransaction;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;

public class NtTransNotifyChange
extends SmbComNtTransaction {
    int fid;
    private int completionFilter;
    private boolean watchTree;

    public NtTransNotifyChange(Configuration config, int fid, int completionFilter, boolean watchTree) {
        super(config, 4);
        this.fid = fid;
        this.completionFilter = completionFilter;
        this.watchTree = watchTree;
        this.setupCount = 4;
        this.totalDataCount = 0;
        this.maxDataCount = 0;
        this.maxParameterCount = config.getNotifyBufferSize();
        this.maxSetupCount = 0;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt4(this.completionFilter, dst, dstIndex);
        SMBUtil.writeInt2(this.fid, dst, dstIndex += 4);
        dstIndex += 2;
        dst[dstIndex++] = this.watchTree ? (byte)1 : 0;
        dst[dstIndex++] = 0;
        return dstIndex - start;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("NtTransNotifyChange[" + super.toString() + ",fid=0x" + Hexdump.toHexString(this.fid, 4) + ",filter=0x" + Hexdump.toHexString(this.completionFilter, 4) + ",watchTree=" + this.watchTree + "]");
    }
}

